/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook;

import facebook4j.Facebook;
import facebook4j.Reading;
import facebook4j.json.DataObjectFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.facebook.FacebookEndpoint;
import org.apache.camel.component.facebook.data.FacebookMethodsType;
import org.apache.camel.component.facebook.data.FacebookMethodsTypeHelper;
import org.apache.camel.component.facebook.data.FacebookPropertiesHelper;
import org.apache.camel.component.facebook.data.ReadingBuilder;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacebookConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(FacebookConsumer.class);
    private static final String SINCE_PREFIX = "since=";
    private final FacebookEndpoint endpoint;
    private final FacebookMethodsType method;
    private final Map<String, Object> endpointProperties;
    private String sinceTime;
    private String untilTime;

    public FacebookConsumer(FacebookEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.method = this.findMethod();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        FacebookPropertiesHelper.getEndpointProperties(endpoint.getConfiguration(), properties);
        Reading reading = (Reading)properties.get("reading");
        if (reading != null) {
            String queryString = reading.toString();
            if (queryString.contains(SINCE_PREFIX)) {
                int startIndex = queryString.indexOf(SINCE_PREFIX) + SINCE_PREFIX.length();
                int endIndex = queryString.indexOf(38, startIndex);
                if (endIndex == -1) {
                    endIndex = queryString.length() - 1;
                }
                String strSince = queryString.substring(startIndex, endIndex);
                try {
                    this.sinceTime = URLDecoder.decode(strSince, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeCamelException(String.format("Error decoding %s.since with value %s due to: %s", "reading.", strSince, e.getMessage()), (Throwable)e);
                }
                LOG.debug("Using supplied property {}since value {}", (Object)"reading.", (Object)this.sinceTime);
            }
            if (queryString.contains("until=")) {
                LOG.debug("Overriding configured property {}until", (Object)"reading.");
            }
        }
        this.endpointProperties = Collections.unmodifiableMap(properties);
    }

    public boolean isGreedy() {
        return false;
    }

    private FacebookMethodsType findMethod() {
        FacebookMethodsType result;
        HashSet<String> argNames = new HashSet<String>();
        argNames.addAll(FacebookPropertiesHelper.getEndpointPropertyNames(this.endpoint.getConfiguration()));
        argNames.add("reading");
        String[] argNamesArray = argNames.toArray(new String[argNames.size()]);
        List<FacebookMethodsType> filteredMethods = FacebookMethodsTypeHelper.filterMethods(this.endpoint.getCandidates(), FacebookMethodsTypeHelper.MatchType.SUPER_SET, argNamesArray);
        if (filteredMethods.isEmpty()) {
            throw new IllegalArgumentException(String.format("Missing properties for %s, need one or more from %s", this.endpoint.getMethodName(), FacebookMethodsTypeHelper.getMissingProperties(this.endpoint.getMethodName(), this.endpoint.getNameStyle(), argNames)));
        }
        if (filteredMethods.size() == 1) {
            result = filteredMethods.get(0);
        } else {
            result = FacebookMethodsTypeHelper.getHighestPriorityMethod(filteredMethods);
            LOG.warn("Using highest priority method {} from methods {}", (Object)this.method, filteredMethods);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Map<String, Object> args = this.getMethodArguments();
        try {
            Object result;
            String rawJSON = null;
            if (this.endpoint.getConfiguration().getJsonStoreEnabled() == null || !this.endpoint.getConfiguration().getJsonStoreEnabled().booleanValue()) {
                result = FacebookMethodsTypeHelper.invokeMethod(this.endpoint.getConfiguration().getFacebook(), this.method, args);
            } else {
                Facebook facebook;
                Facebook facebook2 = facebook = this.endpoint.getConfiguration().getFacebook();
                synchronized (facebook2) {
                    result = FacebookMethodsTypeHelper.invokeMethod(facebook, this.method, args);
                    rawJSON = DataObjectFactory.getRawJSON(result);
                }
            }
            if (result != null && (result instanceof Collection || result.getClass().isArray())) {
                Object array = this.getResultAsArray(result);
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    this.processResult(Array.get(array, i), rawJSON);
                }
                return length;
            }
            this.processResult(result, rawJSON);
            return 1;
        }
        catch (Throwable t) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult(Object result, String rawJSON) throws Exception {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody(result);
        if (rawJSON != null) {
            exchange.getIn().setHeader("CamelFacebook.rawJSON", (Object)rawJSON);
        }
        try {
            this.getProcessor().process(exchange);
        }
        finally {
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }

    private Object getResultAsArray(Object result) {
        if (result.getClass().isArray()) {
            return result;
        }
        Collection collection = (Collection)result;
        return collection.toArray(new Object[collection.size()]);
    }

    private Map<String, Object> getMethodArguments() {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.putAll(this.endpointProperties);
        Reading reading = (Reading)arguments.remove("reading");
        if (reading == null) {
            reading = new Reading();
        } else {
            try {
                reading = ReadingBuilder.copy(reading, true);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("Error creating property [%s]: %s", "reading", e.getMessage()), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Error creating property [%s]: %s", "reading", e.getMessage()), e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        long currentMillis = System.currentTimeMillis();
        if (this.sinceTime == null) {
            Date startTime = new Date(currentMillis - TimeUnit.MILLISECONDS.convert(this.getInitialDelay(), this.getTimeUnit()));
            this.sinceTime = dateFormat.format(startTime);
        } else if (this.untilTime != null) {
            this.sinceTime = this.untilTime;
        }
        this.untilTime = dateFormat.format(new Date(currentMillis));
        reading.since(this.sinceTime);
        reading.until(this.untilTime);
        arguments.put("reading", reading);
        return arguments;
    }
}

