/*
 * Decompiled with CFR 0.152.
 */
package facebook4j;

import facebook4j.FeedTargetingParameter;
import facebook4j.Media;
import facebook4j.TargetingParameter;
import facebook4j.internal.http.HttpParameter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;

public class PagePhotoUpdate
implements Serializable {
    private static final long serialVersionUID = -2690799855513822140L;
    private Media source;
    private URL url;
    private String message;
    private String place;
    private Boolean noStory;
    private TargetingParameter targeting;
    private FeedTargetingParameter feedTargeting;
    private Boolean published;
    private Integer scheduledPublishTime;

    public PagePhotoUpdate(Media source) {
        this.source = source;
    }

    public PagePhotoUpdate(URL url) {
        this.url = url;
    }

    public Media getSource() {
        return this.source;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public PagePhotoUpdate message(String message) {
        this.setMessage(message);
        return this;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public PagePhotoUpdate place(String place) {
        this.setPlace(place);
        return this;
    }

    public Boolean getNoStory() {
        return this.noStory;
    }

    public void setNoStory(boolean noStory) {
        this.noStory = noStory;
    }

    public PagePhotoUpdate noStory(boolean noStory) {
        this.setNoStory(noStory);
        return this;
    }

    public TargetingParameter getTargeting() {
        return this.targeting;
    }

    public void setTargeting(TargetingParameter targeting) {
        this.targeting = targeting;
    }

    public PagePhotoUpdate targeting(TargetingParameter targetingParameter) {
        this.setTargeting(targetingParameter);
        return this;
    }

    public FeedTargetingParameter getFeedTargeting() {
        return this.feedTargeting;
    }

    public void setFeedTargeting(FeedTargetingParameter feedTargeting) {
        this.feedTargeting = feedTargeting;
    }

    public PagePhotoUpdate feedTargeting(FeedTargetingParameter feedTargeting) {
        this.setFeedTargeting(feedTargeting);
        return this;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean published) {
        this.published = published;
    }

    public PagePhotoUpdate published(boolean published) {
        this.setPublished(published);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer scheduledPublishTime) {
        this.scheduledPublishTime = scheduledPublishTime;
    }

    public void setScheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        this.setScheduledPublishTime(Long.valueOf(time).intValue());
    }

    public PagePhotoUpdate scheduledPublishTime(Integer scheduledPublishTime) {
        this.setScheduledPublishTime(scheduledPublishTime);
        return this;
    }

    public PagePhotoUpdate scheduledPublishTime(Date scheduledPublishTime) {
        long time = scheduledPublishTime.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(time).intValue());
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (this.source != null) {
            params.add(new HttpParameter("source", this.source.getMediaFile()));
        }
        if (this.url != null) {
            params.add(new HttpParameter("url", this.url.toString()));
        }
        if (this.message != null) {
            params.add(new HttpParameter("message", this.message));
        }
        if (this.place != null) {
            params.add(new HttpParameter("place", this.place));
        }
        if (this.noStory != null && this.noStory.booleanValue()) {
            params.add(new HttpParameter("no_story", 1));
        }
        if (this.targeting != null) {
            params.add(new HttpParameter("targeting", this.targeting.asJSONString()));
        }
        if (this.feedTargeting != null) {
            params.add(new HttpParameter("feed_targeting", this.feedTargeting.asJSONString()));
        }
        if (this.published != null) {
            params.add(new HttpParameter("published", this.published));
        }
        if (this.scheduledPublishTime != null) {
            params.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PagePhotoUpdate)) {
            return false;
        }
        PagePhotoUpdate that = (PagePhotoUpdate)o;
        if (this.feedTargeting != null ? !this.feedTargeting.equals(that.feedTargeting) : that.feedTargeting != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.noStory != null ? !this.noStory.equals(that.noStory) : that.noStory != null) {
            return false;
        }
        if (this.place != null ? !this.place.equals(that.place) : that.place != null) {
            return false;
        }
        if (this.published != null ? !this.published.equals(that.published) : that.published != null) {
            return false;
        }
        if (this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(that.scheduledPublishTime) : that.scheduledPublishTime != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.targeting != null ? !this.targeting.equals(that.targeting) : that.targeting != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.place != null ? this.place.hashCode() : 0);
        result = 31 * result + (this.noStory != null ? this.noStory.hashCode() : 0);
        result = 31 * result + (this.targeting != null ? this.targeting.hashCode() : 0);
        result = 31 * result + (this.feedTargeting != null ? this.feedTargeting.hashCode() : 0);
        result = 31 * result + (this.published != null ? this.published.hashCode() : 0);
        result = 31 * result + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PagePhotoUpdate{source=" + this.source + ", url=" + this.url + ", message='" + this.message + '\'' + ", place='" + this.place + '\'' + ", noStory=" + this.noStory + ", targeting=" + this.targeting + ", feedTargeting=" + this.feedTargeting + ", published=" + this.published + ", scheduledPublishTime=" + this.scheduledPublishTime + '}';
    }
}

