/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Category;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.Image;
import facebook4j.Like;
import facebook4j.PagableList;
import facebook4j.Photo;
import facebook4j.Place;
import facebook4j.ResponseList;
import facebook4j.Tag;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ImageJSONImpl;
import facebook4j.internal.json.LikeJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.PlaceJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.json.TagJSONImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhotoJSONImpl
extends FacebookResponseImpl
implements Photo,
Serializable {
    private static final long serialVersionUID = 831715533023012050L;
    private String id;
    private Category from;
    private PagableList<Tag> tags;
    private String name;
    private URL icon;
    private URL picture;
    private URL source;
    private Integer height;
    private Integer width;
    private List<Image> images;
    private URL link;
    private Place place;
    private Date createdTime;
    private Date updatedTime;
    private Integer position;
    private PagableList<Comment> comments;
    private PagableList<Like> likes;
    private Category album;

    PhotoJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    PhotoJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            int i;
            int size;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new CategoryJSONImpl(fromJSONObject);
            }
            if (!json.isNull("tags")) {
                JSONObject tagsJSONObject = json.getJSONObject("tags");
                JSONArray list = tagsJSONObject.getJSONArray("data");
                size = list.length();
                this.tags = new PagableListImpl<Tag>(size, tagsJSONObject, new Tag[0]);
                for (i = 0; i < size; ++i) {
                    TagJSONImpl tag = new TagJSONImpl(list.getJSONObject(i));
                    this.tags.add(tag);
                }
            } else {
                this.tags = new PagableListImpl<Tag>();
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.icon = z_F4JInternalParseUtil.getURL("icon", json);
            this.picture = z_F4JInternalParseUtil.getURL("picture", json);
            this.source = z_F4JInternalParseUtil.getURL("source", json);
            if (!json.isNull("height")) {
                this.height = z_F4JInternalParseUtil.getPrimitiveInt("height", json);
            }
            if (!json.isNull("width")) {
                this.width = z_F4JInternalParseUtil.getPrimitiveInt("width", json);
            }
            if (!json.isNull("images")) {
                this.images = new ArrayList<Image>();
                JSONArray imagesJSONArray = json.getJSONArray("images");
                for (int i2 = 0; i2 < imagesJSONArray.length(); ++i2) {
                    JSONObject imageJSONObject = imagesJSONArray.getJSONObject(i2);
                    this.images.add(new ImageJSONImpl(imageJSONObject));
                }
            } else {
                this.images = Collections.emptyList();
            }
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            if (!json.isNull("place")) {
                JSONObject placeJSONObject = json.getJSONObject("place");
                this.place = new PlaceJSONImpl(placeJSONObject);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            if (!json.isNull("position")) {
                this.position = z_F4JInternalParseUtil.getPrimitiveInt("position", json);
            }
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                if (!commentsJSONObject.isNull("data")) {
                    JSONArray list = commentsJSONObject.getJSONArray("data");
                    size = list.length();
                    this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                    for (i = 0; i < size; ++i) {
                        CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                        this.comments.add(comment);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, commentsJSONObject, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!json.isNull("likes")) {
                JSONObject likesJSONObject = json.getJSONObject("likes");
                if (!likesJSONObject.isNull("data")) {
                    JSONArray list = likesJSONObject.getJSONArray("data");
                    size = list.length();
                    this.likes = new PagableListImpl<Like>(size, likesJSONObject, new Like[0]);
                    for (i = 0; i < size; ++i) {
                        LikeJSONImpl like = new LikeJSONImpl(list.getJSONObject(i));
                        this.likes.add(like);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, likesJSONObject, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            if (!json.isNull("album")) {
                this.album = new CategoryJSONImpl(json.getJSONObject("album"));
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public PagableList<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public List<Image> getImages() {
        return this.images;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public Category getAlbum() {
        return this.album;
    }

    static ResponseList<Photo> createPhotoList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Photo> photos = new ResponseListImpl<Photo>(size, json, new Photo[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject photoJSONObject = list.getJSONObject(i);
                PhotoJSONImpl photo = new PhotoJSONImpl(photoJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(photo, photoJSONObject);
                }
                photos.add(photo);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(photos, list);
            }
            return photos;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhotoJSONImpl other = (PhotoJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "PhotoJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", tags=" + this.tags + ", name='" + this.name + '\'' + ", icon=" + this.icon + ", picture=" + this.picture + ", source=" + this.source + ", height=" + this.height + ", width=" + this.width + ", images=" + this.images + ", link=" + this.link + ", place=" + this.place + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", position=" + this.position + ", comments=" + this.comments + ", likes=" + this.likes + ", album=" + this.album + '}';
    }
}

