/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.http;

import facebook4j.internal.http.HttpClient;
import facebook4j.internal.http.HttpClientConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class HttpClientFactory {
    private static final Constructor HTTP_CLIENT_CONSTRUCTOR;
    private static final String HTTP_CLIENT_IMPLEMENTATION = "facebook4j.http.httpClient";

    public static HttpClient getInstance(HttpClientConfiguration conf) {
        try {
            return (HttpClient)HTTP_CLIENT_CONSTRUCTOR.newInstance(conf);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        Class<?> clazz = null;
        String httpClientImpl = System.getProperty(HTTP_CLIENT_IMPLEMENTATION);
        if (httpClientImpl != null) {
            try {
                clazz = Class.forName(httpClientImpl);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("facebook4j.internal.http.alternative.HttpClientImpl");
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("facebook4j.internal.http.HttpClientImpl");
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError((Object)cnfe);
            }
        }
        try {
            HTTP_CLIENT_CONSTRUCTOR = clazz.getConstructor(HttpClientConfiguration.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
    }
}

