/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Admin;
import facebook4j.FacebookException;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AdminJSONImpl
extends FacebookResponseImpl
implements Admin,
Serializable {
    private static final long serialVersionUID = 392257519791459917L;
    private String id;
    private String name;
    private String role;
    private List<String> perms;

    AdminJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    AdminJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        this.id = z_F4JInternalParseUtil.getRawString("id", json);
        this.name = z_F4JInternalParseUtil.getRawString("name", json);
        this.role = z_F4JInternalParseUtil.getRawString("role", json);
        if (!json.isNull("perms")) {
            try {
                JSONArray permsJSONArray = json.getJSONArray("perms");
                int size = permsJSONArray.length();
                this.perms = new ArrayList<String>(size);
                for (int i = 0; i < permsJSONArray.length(); ++i) {
                    this.perms.add(permsJSONArray.getString(i));
                }
            }
            catch (JSONException jsone) {
                throw new FacebookException(jsone);
            }
        } else {
            this.perms = Collections.emptyList();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public List<String> getPerms() {
        return this.perms;
    }

    static ResponseList<Admin> createAdminList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Admin> admins = new ResponseListImpl<Admin>(size, json, new Admin[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject adminJSONObject = list.getJSONObject(i);
                AdminJSONImpl admin = new AdminJSONImpl(adminJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(admin, adminJSONObject);
                }
                admins.add(admin);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(admins, list);
            }
            return admins;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdminJSONImpl other = (AdminJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AdminJSONImpl{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", role='" + this.role + '\'' + ", perms=" + this.perms + '}';
    }
}

