/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.Album;
import facebook4j.Category;
import facebook4j.Comment;
import facebook4j.FacebookException;
import facebook4j.Like;
import facebook4j.PagableList;
import facebook4j.Picture;
import facebook4j.Place;
import facebook4j.PrivacyType;
import facebook4j.Reaction;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.CategoryJSONImpl;
import facebook4j.internal.json.CommentJSONImpl;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.LikeJSONImpl;
import facebook4j.internal.json.PagableListImpl;
import facebook4j.internal.json.PictureJSONImpl;
import facebook4j.internal.json.PlaceJSONImpl;
import facebook4j.internal.json.ReactionJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AlbumJSONImpl
extends FacebookResponseImpl
implements Album,
Serializable {
    private static final long serialVersionUID = 4708626697445405636L;
    private String id;
    private Category from;
    private String name;
    private String description;
    private String location;
    private URL link;
    private String coverPhoto;
    private PrivacyType privacy;
    private Integer count;
    private String type;
    private Date createdTime;
    private Date updatedTime;
    private Boolean canUpload;
    private Place place;
    private Picture picture;
    private PagableList<Like> likes;
    private PagableList<Comment> comments;
    private PagableList<Reaction> reactions;

    AlbumJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    AlbumJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            int i;
            int size;
            JSONArray list;
            JSONObject pictureJSONObject;
            this.id = z_F4JInternalParseUtil.getRawString("id", json);
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new CategoryJSONImpl(fromJSONObject);
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", json);
            this.description = z_F4JInternalParseUtil.getRawString("description", json);
            this.location = z_F4JInternalParseUtil.getRawString("location", json);
            this.link = z_F4JInternalParseUtil.getURL("link", json);
            this.coverPhoto = z_F4JInternalParseUtil.getRawString("cover_photo", json);
            this.privacy = PrivacyType.getInstance(z_F4JInternalParseUtil.getRawString("privacy", json));
            this.count = z_F4JInternalParseUtil.getInt("count", json);
            this.type = z_F4JInternalParseUtil.getRawString("type", json);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", json);
            this.canUpload = z_F4JInternalParseUtil.getBoolean("can_upload", json);
            if (!json.isNull("place")) {
                JSONObject placeJSONObject = json.getJSONObject("place");
                this.place = new PlaceJSONImpl(placeJSONObject);
            }
            if (!json.isNull("picture") && !(pictureJSONObject = json.getJSONObject("picture")).isNull("data")) {
                this.picture = new PictureJSONImpl(pictureJSONObject);
            }
            if (!json.isNull("likes")) {
                JSONObject likesJSONObject = json.getJSONObject("likes");
                if (!likesJSONObject.isNull("data")) {
                    list = likesJSONObject.getJSONArray("data");
                    size = list.length();
                    this.likes = new PagableListImpl<Like>(size, likesJSONObject, new Like[0]);
                    for (i = 0; i < size; ++i) {
                        LikeJSONImpl like = new LikeJSONImpl(list.getJSONObject(i));
                        this.likes.add(like);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, likesJSONObject, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            if (!json.isNull("comments")) {
                JSONObject commentsJSONObject = json.getJSONObject("comments");
                if (!commentsJSONObject.isNull("data")) {
                    list = commentsJSONObject.getJSONArray("data");
                    size = list.length();
                    this.comments = new PagableListImpl<Comment>(size, commentsJSONObject, new Comment[0]);
                    for (i = 0; i < size; ++i) {
                        CommentJSONImpl comment = new CommentJSONImpl(list.getJSONObject(i));
                        this.comments.add(comment);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, commentsJSONObject, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!json.isNull("reactions")) {
                JSONObject reactionsJSONObject = json.getJSONObject("reactions");
                if (!reactionsJSONObject.isNull("data")) {
                    list = reactionsJSONObject.getJSONArray("data");
                    size = list.length();
                    this.reactions = new PagableListImpl<Reaction>(size, reactionsJSONObject, new Reaction[0]);
                    for (i = 0; i < size; ++i) {
                        ReactionJSONImpl reaction = new ReactionJSONImpl(list.getJSONObject(i));
                        this.reactions.add(reaction);
                    }
                } else {
                    this.reactions = new PagableListImpl<Reaction>(1, reactionsJSONObject, new Reaction[0]);
                }
            } else {
                this.reactions = new PagableListImpl<Reaction>(0);
            }
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getCoverPhoto() {
        return this.coverPhoto;
    }

    @Override
    public PrivacyType getPrivacy() {
        return this.privacy;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Boolean canUpload() {
        return this.canUpload;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Picture getPicture() {
        return this.picture;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public PagableList<Reaction> getReactions() {
        return this.reactions;
    }

    static ResponseList<Album> createAlbumList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<Album> albums = new ResponseListImpl<Album>(size, json, new Album[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject albumJSONObject = list.getJSONObject(i);
                AlbumJSONImpl album = new AlbumJSONImpl(albumJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(album, albumJSONObject);
                }
                albums.add(album);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(albums, list);
            }
            return albums;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlbumJSONImpl other = (AlbumJSONImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "AlbumJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", location='" + this.location + '\'' + ", link=" + this.link + ", coverPhoto='" + this.coverPhoto + '\'' + ", privacy=" + (Object)((Object)this.privacy) + ", count=" + this.count + ", type='" + this.type + '\'' + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", canUpload=" + this.canUpload + ", place=" + this.place + ", picture=" + this.picture + ", likes=" + this.likes + ", comments=" + this.comments + '}';
    }
}

