/*
 * Decompiled with CFR 0.152.
 */
package facebook4j.internal.json;

import facebook4j.FacebookException;
import facebook4j.FriendRequest;
import facebook4j.IdNameEntity;
import facebook4j.ResponseList;
import facebook4j.conf.Configuration;
import facebook4j.internal.http.HttpResponse;
import facebook4j.internal.json.DataObjectFactoryUtil;
import facebook4j.internal.json.FacebookResponseImpl;
import facebook4j.internal.json.IdNameEntityJSONImpl;
import facebook4j.internal.json.ResponseListImpl;
import facebook4j.internal.org.json.JSONArray;
import facebook4j.internal.org.json.JSONException;
import facebook4j.internal.org.json.JSONObject;
import facebook4j.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FriendRequestJSONImpl
extends FacebookResponseImpl
implements FriendRequest,
Serializable {
    private static final long serialVersionUID = 6531121120616740631L;
    private IdNameEntity from;
    private IdNameEntity to;
    private Date createdTime;
    private String message;
    private Boolean unread;

    FriendRequestJSONImpl(HttpResponse res, Configuration conf) throws FacebookException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    FriendRequestJSONImpl(JSONObject json) throws FacebookException {
        this.init(json);
    }

    private void init(JSONObject json) throws FacebookException {
        try {
            if (!json.isNull("from")) {
                JSONObject fromJSONObject = json.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(fromJSONObject);
            } else {
                this.from = null;
            }
            if (!json.isNull("to")) {
                JSONObject toJSONObject = json.getJSONObject("to");
                this.to = new IdNameEntityJSONImpl(toJSONObject);
            } else {
                this.to = null;
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", json);
            this.message = z_F4JInternalParseUtil.getRawString("message", json);
            this.unread = z_F4JInternalParseUtil.getBoolean("unread", json);
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone.getMessage(), jsone);
        }
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public IdNameEntity getTo() {
        return this.to;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Boolean unread() {
        return this.unread;
    }

    static ResponseList<FriendRequest> createFriendRequestList(HttpResponse res, Configuration conf) throws FacebookException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject json = res.asJSONObject();
            JSONArray list = json.getJSONArray("data");
            int size = list.length();
            ResponseListImpl<FriendRequest> friendRequests = new ResponseListImpl<FriendRequest>(size, json, new FriendRequest[0]);
            for (int i = 0; i < size; ++i) {
                JSONObject friendRequestJSONObject = list.getJSONObject(i);
                FriendRequestJSONImpl friendRequest = new FriendRequestJSONImpl(friendRequestJSONObject);
                if (conf.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(friendRequest, friendRequestJSONObject);
                }
                friendRequests.add(friendRequest);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(friendRequests, list);
            }
            return friendRequests;
        }
        catch (JSONException jsone) {
            throw new FacebookException(jsone);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.createdTime == null ? 0 : this.createdTime.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FriendRequestJSONImpl other = (FriendRequestJSONImpl)obj;
        if (this.createdTime == null ? other.createdTime != null : !this.createdTime.equals(other.createdTime)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    public String toString() {
        return "FriendRequestJSONImpl [from=" + this.from + ", to=" + this.to + ", createdTime=" + this.createdTime + ", unread=" + this.unread + "]";
    }
}

