/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.component.facebook.FacebookEndpoint;
import org.apache.camel.component.facebook.config.FacebookConfiguration;
import org.apache.camel.component.facebook.config.FacebookEndpointConfiguration;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;

@Component(value="facebook")
public class FacebookComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private FacebookConfiguration configuration;

    public FacebookComponent() {
        this(new FacebookConfiguration());
    }

    public FacebookComponent(FacebookConfiguration configuration) {
        this(null, configuration);
    }

    public FacebookComponent(CamelContext context) {
        this(context, new FacebookConfiguration());
    }

    public FacebookComponent(CamelContext context, FacebookConfiguration configuration) {
        super(context);
        this.configuration = configuration;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        FacebookEndpointConfiguration config = this.copyComponentProperties();
        FacebookEndpoint endpoint = new FacebookEndpoint(uri, this, remaining, config);
        this.setProperties(endpoint, parameters);
        this.setProperties(endpoint, parameters);
        this.validateParameters(uri, parameters, null);
        return endpoint;
    }

    private FacebookEndpointConfiguration copyComponentProperties() {
        HashMap<String, Object> componentProperties = new HashMap<String, Object>();
        BeanIntrospection beanIntrospection = this.getCamelContext().adapt(ExtendedCamelContext.class).getBeanIntrospection();
        beanIntrospection.getProperties(this.configuration, componentProperties, null, false);
        FacebookEndpointConfiguration config = new FacebookEndpointConfiguration();
        PropertyBindingSupport.bindProperties(this.getCamelContext(), config, componentProperties);
        return config;
    }

    public FacebookConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(FacebookConfiguration configuration) {
        this.configuration = configuration;
    }
}

