/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.facebook.FacebookComponent;
import org.apache.camel.component.facebook.FacebookConstants;
import org.apache.camel.component.facebook.FacebookConsumer;
import org.apache.camel.component.facebook.FacebookProducer;
import org.apache.camel.component.facebook.config.FacebookEndpointConfiguration;
import org.apache.camel.component.facebook.config.FacebookNameStyle;
import org.apache.camel.component.facebook.data.FacebookMethodsType;
import org.apache.camel.component.facebook.data.FacebookMethodsTypeHelper;
import org.apache.camel.component.facebook.data.FacebookPropertiesHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.14.0", scheme="facebook", title="Facebook", syntax="facebook:methodName", category={Category.SOCIAL}, headersClass=FacebookConstants.class)
public class FacebookEndpoint
extends DefaultEndpoint
implements FacebookConstants {
    private static final Logger LOG = LoggerFactory.getLogger(FacebookEndpoint.class);
    private FacebookNameStyle nameStyle;
    @UriPath(name="methodName", description="What operation to perform")
    @Metadata(required=true)
    private String method;
    @UriParam
    private FacebookEndpointConfiguration configuration;
    @UriParam
    private String inBody;
    private List<FacebookMethodsType> candidates;

    public FacebookEndpoint(String uri, FacebookComponent facebookComponent, String remaining, FacebookEndpointConfiguration configuration) {
        super(uri, facebookComponent);
        this.configuration = configuration;
        this.method = remaining;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new FacebookProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        FacebookConsumer consumer = new FacebookConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
        super.configureProperties(options);
        try {
            if (this.configuration == null) {
                this.configuration = new FacebookEndpointConfiguration();
            }
            PropertyBindingSupport.bindProperties(this.getCamelContext(), this.configuration, options);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        FacebookPropertiesHelper.configureReadingProperties(this.configuration, options);
        this.configuration.validate();
        this.initState();
    }

    private void initState() {
        Set<String> missing;
        HashSet<String> arguments = new HashSet<String>();
        arguments.addAll(FacebookPropertiesHelper.getEndpointPropertyNames(this.getCamelContext(), this.configuration));
        if (this.inBody != null) {
            arguments.add(this.inBody);
        }
        String[] argNames = arguments.toArray(new String[arguments.size()]);
        this.candidates = new ArrayList<FacebookMethodsType>();
        this.candidates.addAll(FacebookMethodsTypeHelper.getCandidateMethods(this.method, argNames));
        if (!this.candidates.isEmpty()) {
            this.nameStyle = FacebookNameStyle.EXACT;
        } else {
            this.candidates.addAll(FacebookMethodsTypeHelper.getCandidateMethods(FacebookMethodsTypeHelper.convertToGetMethod(this.method), argNames));
            if (!this.candidates.isEmpty()) {
                this.nameStyle = FacebookNameStyle.GET;
            }
            int nGetMethods = this.candidates.size();
            this.candidates.addAll(FacebookMethodsTypeHelper.getCandidateMethods(FacebookMethodsTypeHelper.convertToSearchMethod(this.method), argNames));
            if (this.candidates.isEmpty()) {
                throw new IllegalArgumentException(String.format("No matching operation for %s, with arguments %s", this.method, arguments));
            }
            if (this.nameStyle == null) {
                this.nameStyle = FacebookNameStyle.SEARCH;
            } else if (this.candidates.size() > nGetMethods) {
                this.nameStyle = FacebookNameStyle.GET_AND_SEARCH;
            }
        }
        if (LOG.isDebugEnabled() && !(missing = FacebookMethodsTypeHelper.getMissingProperties(this.method, this.nameStyle, arguments)).isEmpty()) {
            LOG.debug("Method {} could use one or more properties from {}", (Object)this.method, missing);
        }
    }

    public FacebookEndpointConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<FacebookMethodsType> getCandidates() {
        return Collections.unmodifiableList(this.candidates);
    }

    public String getInBody() {
        return this.inBody;
    }

    public String getMethod() {
        return this.method;
    }

    public FacebookNameStyle getNameStyle() {
        return this.nameStyle;
    }

    public void setInBody(String inBody) {
        ObjectHelper.notNull(inBody, "inBody");
        if (!FacebookPropertiesHelper.getValidEndpointProperties().contains(inBody)) {
            throw new IllegalArgumentException("Unknown property " + inBody);
        }
        this.inBody = inBody;
    }

    public void setConfiguration(FacebookEndpointConfiguration configuration) {
        this.configuration = configuration;
    }
}

