/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.PropertiesInterceptor;
import org.apache.camel.support.component.PropertyNamesInterceptor;
import org.apache.camel.support.component.ResultInterceptor;

public abstract class AbstractApiConsumer<E extends Enum<E>, T>
extends ScheduledPollConsumer
implements PropertyNamesInterceptor,
PropertiesInterceptor,
ResultInterceptor {
    protected final AbstractApiEndpoint<E, T> endpoint;
    protected final ApiMethod method;
    private boolean splitResult = true;

    public AbstractApiConsumer(AbstractApiEndpoint<E, T> endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.method = ApiConsumerHelper.findMethod(endpoint, this);
    }

    @Override
    public boolean isGreedy() {
        return false;
    }

    @Override
    protected int poll() throws Exception {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.putAll(this.endpoint.getEndpointProperties());
        this.endpoint.interceptProperties(args);
        this.interceptProperties(args);
        try {
            Object result = this.doInvokeMethod(args);
            return ApiConsumerHelper.getResultsProcessed(this, result, this.isSplitResult());
        }
        catch (Throwable t) {
            throw RuntimeCamelException.wrapRuntimeCamelException(t);
        }
    }

    @Override
    public void interceptPropertyNames(Set<String> propertyNames) {
    }

    @Override
    public void interceptProperties(Map<String, Object> properties) {
    }

    protected Object doInvokeMethod(Map<String, Object> args) {
        return ApiMethodHelper.invokeMethod(this.endpoint.getApiProxy(this.method, args), this.method, args);
    }

    @Override
    public Object splitResult(Object result) {
        return result;
    }

    @Override
    public void interceptResult(Object result, Exchange resultExchange) {
    }

    public final boolean isSplitResult() {
        return this.splitResult;
    }

    public final void setSplitResult(boolean splitResult) {
        this.splitResult = splitResult;
    }
}

