/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.AdviceWithTasks;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.MockSendToEndpointStrategyFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingConsumer;

public abstract class AdviceWithRouteBuilder
extends RouteBuilder {
    private RouteDefinition originalRoute;
    private final List<AdviceWithTask> adviceWithTasks = new ArrayList<AdviceWithTask>();
    private boolean logRouteAsXml = true;

    public AdviceWithRouteBuilder() {
    }

    public AdviceWithRouteBuilder(CamelContext context) {
        super(context);
    }

    @Deprecated
    public static RouteDefinition adviceWith(CamelContext camelContext, Object routeId, ThrowingConsumer<AdviceWithRouteBuilder, Exception> builder) throws Exception {
        return AdviceWith.adviceWith(camelContext, routeId, builder);
    }

    @Deprecated
    public static RouteDefinition adviceWith(CamelContext camelContext, Object routeId, boolean logXml, ThrowingConsumer<AdviceWithRouteBuilder, Exception> builder) throws Exception {
        return AdviceWith.adviceWith(camelContext, routeId, logXml, builder);
    }

    public void setOriginalRoute(RouteDefinition originalRoute) {
        this.originalRoute = originalRoute;
    }

    public RouteDefinition getOriginalRoute() {
        return this.originalRoute;
    }

    public boolean isLogRouteAsXml() {
        return this.logRouteAsXml;
    }

    public void setLogRouteAsXml(boolean logRouteAsXml) {
        this.logRouteAsXml = logRouteAsXml;
    }

    public List<AdviceWithTask> getAdviceWithTasks() {
        return this.adviceWithTasks;
    }

    public void mockEndpoints() throws Exception {
        this.getContext().adapt(ExtendedCamelContext.class).registerEndpointCallback(this.createMockEndpointStrategy(null, false));
    }

    public void mockEndpoints(String ... pattern) throws Exception {
        for (String s : pattern) {
            this.getContext().adapt(ExtendedCamelContext.class).registerEndpointCallback(this.createMockEndpointStrategy(s, false));
        }
    }

    public void mockEndpointsAndSkip(String ... pattern) throws Exception {
        for (String s : pattern) {
            this.getContext().adapt(ExtendedCamelContext.class).registerEndpointCallback(this.createMockEndpointStrategy(s, true));
        }
    }

    public void replaceFromWith(String uri) {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        this.getAdviceWithTasks().add(AdviceWithTasks.replaceFromWith(this.originalRoute, uri));
    }

    public void replaceFromWith(Endpoint endpoint) {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        this.getAdviceWithTasks().add(AdviceWithTasks.replaceFrom(this.originalRoute, endpoint));
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveById(String pattern) {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        return new AdviceWithBuilder(this, pattern, null, null, null);
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveByToString(String pattern) {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        return new AdviceWithBuilder(this, null, pattern, null, null);
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveByToUri(String pattern) {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        return new AdviceWithBuilder(this, null, null, pattern, null);
    }

    public <T extends ProcessorDefinition<?>> AdviceWithBuilder<T> weaveByType(Class<T> type) {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        return new AdviceWithBuilder<T>(this, null, null, null, type);
    }

    public <T extends ProcessorDefinition<?>> ProcessorDefinition<?> weaveAddFirst() {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        return new AdviceWithBuilder(this, "*", null, null, null).selectFirst().before();
    }

    public <T extends ProcessorDefinition<?>> ProcessorDefinition<?> weaveAddLast() {
        ObjectHelper.notNull(this.originalRoute, "originalRoute", this);
        return new AdviceWithBuilder(this, "*", null, null, null).maxDeep(1).selectLast().after();
    }

    private EndpointStrategy createMockEndpointStrategy(String pattern, boolean skip) {
        MockSendToEndpointStrategyFactory factory = this.getContext().adapt(ExtendedCamelContext.class).getFactoryFinder("META-INF/services/org/apache/camel/").newInstance("mock-send-to-endpoint-strategy-factory", MockSendToEndpointStrategyFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot find MockSendToEndpointStrategyFactory on classpath. Add camel-mock to classpath."));
        return factory.mock(pattern, skip);
    }
}

