/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.GenericFileConsumer;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.EventDrivenPollingConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFilePollingConsumer
extends EventDrivenPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFilePollingConsumer.class);
    private final long delay;

    public GenericFilePollingConsumer(GenericFileEndpoint endpoint) throws Exception {
        super(endpoint);
        this.delay = endpoint.getDelay() > 0L ? endpoint.getDelay() : endpoint.getDefaultDelay();
    }

    @Override
    protected Consumer createConsumer() throws Exception {
        GenericFileConsumer consumer = (GenericFileConsumer)super.createConsumer();
        consumer.setStartScheduler(false);
        consumer.setMaxMessagesPerPoll(1);
        consumer.setEagerLimitMaxMessagesPerPoll(false);
        return consumer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.getConsumer());
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
    }

    @Override
    protected GenericFileConsumer getConsumer() {
        return (GenericFileConsumer)super.getConsumer();
    }

    @Override
    public Exchange receiveNoWait() {
        int polled;
        if (LOG.isTraceEnabled()) {
            LOG.trace("receiveNoWait polling file: {}", (Object)this.getConsumer().getEndpoint());
        }
        if ((polled = this.doReceive(0L)) > 0) {
            return super.receive(0L);
        }
        return null;
    }

    @Override
    public Exchange receive() {
        int polled;
        if (LOG.isTraceEnabled()) {
            LOG.trace("receive polling file: {}", (Object)this.getConsumer().getEndpoint());
        }
        if ((polled = this.doReceive(Long.MAX_VALUE)) > 0) {
            return super.receive();
        }
        return null;
    }

    @Override
    public Exchange receive(long timeout) {
        int polled;
        if (LOG.isTraceEnabled()) {
            LOG.trace("receive({}) polling file: {}", (Object)timeout, (Object)this.getConsumer().getEndpoint());
        }
        if ((polled = this.doReceive(timeout)) > 0) {
            return super.receive(timeout);
        }
        return null;
    }

    protected int doReceive(long timeout) {
        int retryCounter = -1;
        boolean done = false;
        Throwable cause = null;
        int polledMessages = 0;
        PollingConsumerPollStrategy pollStrategy = this.getConsumer().getPollStrategy();
        boolean sendEmptyMessageWhenIdle = this.getConsumer().isSendEmptyMessageWhenIdle();
        StopWatch watch = new StopWatch();
        while (!done) {
            try {
                cause = null;
                done = true;
                if (this.isRunAllowed()) {
                    if (retryCounter == -1) {
                        LOG.trace("Starting to poll: {}", (Object)this.getEndpoint());
                    } else {
                        LOG.debug("Retrying attempt {} to poll: {}", (Object)retryCounter, (Object)this.getEndpoint());
                    }
                    boolean begin = pollStrategy.begin(this.getConsumer(), this.getEndpoint());
                    if (begin) {
                        ++retryCounter;
                        polledMessages = this.getConsumer().poll();
                        LOG.trace("Polled {} messages", (Object)polledMessages);
                        if (polledMessages == 0 && sendEmptyMessageWhenIdle) {
                            this.processEmptyMessage();
                        } else if (polledMessages == 0 && timeout > 0L) {
                            done = false;
                        }
                        pollStrategy.commit(this.getConsumer(), this.getEndpoint(), polledMessages);
                    } else {
                        LOG.debug("Cannot begin polling as pollStrategy returned false: {}", (Object)pollStrategy);
                    }
                }
                LOG.trace("Finished polling: {}", (Object)this.getEndpoint());
            }
            catch (Exception e) {
                try {
                    boolean retry = pollStrategy.rollback(this.getConsumer(), this.getEndpoint(), retryCounter, e);
                    if (retry) {
                        done = false;
                    }
                    cause = e;
                    done = true;
                }
                catch (Exception t) {
                    cause = t;
                    done = true;
                }
            }
            catch (Throwable t) {
                cause = t;
                done = true;
            }
            if (done || timeout <= 0L) continue;
            long left = timeout - watch.taken();
            long min = Math.min(left, this.delay);
            if (min > 0L) {
                try {
                    this.sleep(min);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            done = true;
        }
        if (cause != null) {
            throw RuntimeCamelException.wrapRuntimeCamelException(cause);
        }
        return polledMessages;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object name = exchange.getIn().getHeader("CamelFileName");
        if (name != null) {
            LOG.debug("Received file: {}", name);
        }
        super.process(exchange);
    }

    protected void processEmptyMessage() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        LOG.debug("Sending empty message as there were no messages from polling: {}", (Object)this.getEndpoint());
        this.process(exchange);
    }

    private void sleep(long delay) throws InterruptedException {
        if (delay <= 0L) {
            return;
        }
        LOG.trace("Sleeping for: {} millis", (Object)delay);
        Thread.sleep(delay);
    }
}

