/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.debugger.BacklogDebugger;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.CamelInternalProcessor;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.ErrorHandlerRedeliveryCustomizer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.WrapAwareProcessor;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannel
extends CamelInternalProcessor
implements Channel {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChannel.class);
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ManagementInterceptStrategy.InstrumentationProcessor<?> instrumentationProcessor;
    private Route route;

    public DefaultChannel(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    @Override
    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    public void setOutput(Processor output) {
        this.output = output;
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    protected void doStart() throws Exception {
        this.setProcessor(this.getOutput());
        ServiceHelper.startService(this.errorHandler, this.output);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.output, this.errorHandler);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.output, this.errorHandler);
    }

    @Override
    public void initChannel(Route route, NamedNode definition, NamedNode childDefinition, List<InterceptStrategy> interceptors, Processor nextProcessor, NamedRoute routeDefinition, boolean first) throws Exception {
        this.route = route;
        this.nextProcessor = nextProcessor;
        if (nextProcessor instanceof CamelContextAware) {
            ((CamelContextAware)((Object)nextProcessor)).setCamelContext(this.camelContext);
        }
        NamedNode targetOutputDef = childDefinition != null ? childDefinition : definition;
        LOG.trace("Initialize channel for target: {}", (Object)targetOutputDef);
        ManagementInterceptStrategy managed = route.getManagementInterceptStrategy();
        if (managed != null) {
            this.instrumentationProcessor = managed.createProcessor(targetOutputDef, nextProcessor);
        }
        if (route.isMessageHistory().booleanValue()) {
            MessageHistoryFactory factory = this.camelContext.getMessageHistoryFactory();
            this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(factory, targetOutputDef));
        }
        this.addAdvice(new CamelInternalProcessor.NodeHistoryAdvice(targetOutputDef));
        if (route.isDebugging().booleanValue()) {
            Service debugger;
            if (this.camelContext.getDebugger() != null) {
                debugger = this.camelContext.getDebugger();
                this.addAdvice(new CamelInternalProcessor.DebuggerAdvice((Debugger)debugger, nextProcessor, targetOutputDef));
            } else {
                debugger = DefaultChannel.getOrCreateBacklogDebugger(this.camelContext);
                this.camelContext.addService(debugger);
                this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice((BacklogDebugger)debugger, nextProcessor, targetOutputDef));
            }
        }
        if (route.isBacklogTracing().booleanValue()) {
            BacklogTracer backlogTracer = DefaultChannel.getOrCreateBacklogTracer(this.camelContext);
            this.addAdvice(new CamelInternalProcessor.BacklogTracerAdvice(backlogTracer, targetOutputDef, routeDefinition, first));
        }
        if (route.isTracing().booleanValue()) {
            Tracer tracer = this.camelContext.getTracer();
            this.addAdvice(new CamelInternalProcessor.TracingAdvice(tracer, targetOutputDef, routeDefinition, first));
        }
        interceptors.sort(OrderedComparator.get());
        Collections.reverse(interceptors);
        Processor target = nextProcessor;
        for (InterceptStrategy strategy : interceptors) {
            Processor next = target == nextProcessor ? null : nextProcessor;
            Processor wrapped = strategy.wrapProcessorInInterceptors(route.getCamelContext(), targetOutputDef, target, next);
            if (!(wrapped instanceof AsyncProcessor)) {
                LOG.warn("Interceptor: {} at: {} does not return an AsyncProcessor instance. This causes the asynchronous routing engine to not work as optimal as possible. See more details at the InterceptStrategy javadoc. Camel will use a bridge to adapt the interceptor to the asynchronous routing engine, but its not the most optimal solution. Please consider changing your interceptor to comply.", (Object)strategy, (Object)definition);
            }
            if (!(wrapped instanceof WrapAwareProcessor)) {
                wrapped = this.camelContext.adapt(ExtendedCamelContext.class).getInternalProcessorFactory().createWrapProcessor(wrapped, target);
            }
            target = wrapped;
        }
        if (route.isStreamCaching().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.StreamCachingAdvice(this.camelContext.getStreamCachingStrategy()));
        }
        if (route.getDelayer() != null && route.getDelayer() > 0L) {
            this.addAdvice(new CamelInternalProcessor.DelayerAdvice(route.getDelayer()));
        }
        this.output = target;
    }

    @Override
    public void postInitChannel() throws Exception {
        if (this.instrumentationProcessor != null) {
            ErrorHandlerRedeliveryCustomizer erh;
            boolean redeliveryPossible = false;
            if (this.errorHandler instanceof ErrorHandlerRedeliveryCustomizer && (redeliveryPossible = (erh = (ErrorHandlerRedeliveryCustomizer)((Object)this.errorHandler)).determineIfRedeliveryIsEnabled())) {
                Processor currentOutput = erh.getOutput();
                this.instrumentationProcessor.setProcessor(currentOutput);
                erh.changeOutput(this.instrumentationProcessor);
            }
            if (!redeliveryPossible) {
                this.addAdvice(CamelInternalProcessor.wrap(this.instrumentationProcessor));
            }
        }
    }

    private static BacklogTracer getOrCreateBacklogTracer(CamelContext camelContext) {
        Map<String, BacklogTracer> map;
        BacklogTracer tracer = null;
        if (camelContext.getRegistry() != null && (map = camelContext.getRegistry().findByTypeWithName(BacklogTracer.class)).size() == 1) {
            tracer = map.values().iterator().next();
        }
        if (tracer == null) {
            tracer = camelContext.getExtension(BacklogTracer.class);
        }
        if (tracer == null) {
            tracer = BacklogTracer.createTracer(camelContext);
            camelContext.setExtension(BacklogTracer.class, tracer);
        }
        return tracer;
    }

    private static BacklogDebugger getOrCreateBacklogDebugger(CamelContext camelContext) {
        Map<String, BacklogDebugger> map;
        BacklogDebugger debugger = null;
        if (camelContext.getRegistry() != null && (map = camelContext.getRegistry().findByTypeWithName(BacklogDebugger.class)).size() == 1) {
            debugger = map.values().iterator().next();
        }
        if (debugger == null) {
            debugger = camelContext.hasService(BacklogDebugger.class);
        }
        if (debugger == null) {
            debugger = BacklogDebugger.createDebugger(camelContext);
        }
        return debugger;
    }

    @Override
    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

