/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consumer;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.PooledObjectFactory;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExchangeFactoryManager
extends ServiceSupport
implements ExchangeFactoryManager,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExchangeFactoryManager.class);
    private final Map<Consumer, ExchangeFactory> factories = new ConcurrentHashMap<Consumer, ExchangeFactory>();
    private final UtilizationStatistics statistics = new UtilizationStatistics();
    private CamelContext camelContext;
    private int capacity;
    private boolean statisticsEnabled;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void addExchangeFactory(ExchangeFactory exchangeFactory) {
        this.factories.put(exchangeFactory.getConsumer(), exchangeFactory);
        this.capacity = exchangeFactory.getCapacity();
        this.statisticsEnabled = exchangeFactory.isStatisticsEnabled();
    }

    @Override
    public void removeExchangeFactory(ExchangeFactory exchangeFactory) {
        this.factories.remove(exchangeFactory.getConsumer());
    }

    @Override
    public Collection<ExchangeFactory> getExchangeFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    @Override
    public int getConsumerCounter() {
        return this.factories.size();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getPooledCounter() {
        int counter = 0;
        for (ExchangeFactory ef : this.factories.values()) {
            counter += ef.getSize();
        }
        return counter;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        for (ExchangeFactory ef : this.factories.values()) {
            ef.setStatisticsEnabled(statisticsEnabled);
        }
    }

    @Override
    public void resetStatistics() {
        this.factories.values().forEach(PooledObjectFactory::resetStatistics);
    }

    @Override
    public void purge() {
        this.factories.values().forEach(PooledObjectFactory::purge);
    }

    @Override
    public PooledObjectFactory.Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    protected void doBuild() throws Exception {
        super.doBuild();
        ExchangeHelper.warmup(LOG);
        UnitOfWorkHelper.warmup(LOG);
        this.camelContext.adapt(ExtendedCamelContext.class).getUnitOfWorkFactory().warmup(LOG);
    }

    @Override
    protected void doShutdown() throws Exception {
        this.factories.clear();
    }

    final class UtilizationStatistics
    implements PooledObjectFactory.Statistics {
        UtilizationStatistics() {
        }

        @Override
        public void reset() {
            DefaultExchangeFactoryManager.this.resetStatistics();
        }

        @Override
        public long getCreatedCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getCreatedCounter();
                }
            }
            return answer;
        }

        @Override
        public long getAcquiredCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getAcquiredCounter();
                }
            }
            return answer;
        }

        @Override
        public long getReleasedCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getReleasedCounter();
                }
            }
            return answer;
        }

        @Override
        public long getDiscardedCounter() {
            long answer = 0L;
            if (DefaultExchangeFactoryManager.this.statisticsEnabled) {
                for (ExchangeFactory ef : DefaultExchangeFactoryManager.this.factories.values()) {
                    answer += ef.getStatistics().getDiscardedCounter();
                }
            }
            return answer;
        }
    }
}

