/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.event.DefaultEventFactory;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultManagementStrategy
extends ServiceSupport
implements ManagementStrategy,
CamelContextAware {
    private final List<EventNotifier> eventNotifiers = new CopyOnWriteArrayList<EventNotifier>();
    private EventFactory eventFactory = new DefaultEventFactory();
    private ManagementObjectNameStrategy managementObjectNameStrategy;
    private ManagementObjectStrategy managementObjectStrategy;
    private ManagementAgent managementAgent;
    private CamelContext camelContext;

    public DefaultManagementStrategy() {
    }

    public DefaultManagementStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public DefaultManagementStrategy(CamelContext camelContext, ManagementAgent managementAgent) {
        this.camelContext = camelContext;
        this.managementAgent = managementAgent;
    }

    @Override
    public List<EventNotifier> getEventNotifiers() {
        return this.eventNotifiers;
    }

    @Override
    public void addEventNotifier(EventNotifier eventNotifier) {
        this.eventNotifiers.add(eventNotifier);
        if (this.getCamelContext() != null && !eventNotifier.isIgnoreExchangeEvents()) {
            this.getCamelContext().adapt(ExtendedCamelContext.class).setEventNotificationApplicable(true);
        }
    }

    @Override
    public boolean removeEventNotifier(EventNotifier eventNotifier) {
        return this.eventNotifiers.remove(eventNotifier);
    }

    @Override
    public EventFactory getEventFactory() {
        return this.eventFactory;
    }

    @Override
    public void setEventFactory(EventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    @Override
    public ManagementObjectNameStrategy getManagementObjectNameStrategy() {
        return this.managementObjectNameStrategy;
    }

    @Override
    public void setManagementObjectNameStrategy(ManagementObjectNameStrategy managementObjectNameStrategy) {
        this.managementObjectNameStrategy = managementObjectNameStrategy;
    }

    @Override
    public ManagementObjectStrategy getManagementObjectStrategy() {
        return this.managementObjectStrategy;
    }

    @Override
    public void setManagementObjectStrategy(ManagementObjectStrategy managementObjectStrategy) {
        this.managementObjectStrategy = managementObjectStrategy;
    }

    @Override
    public ManagementAgent getManagementAgent() {
        return this.managementAgent;
    }

    @Override
    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    @Override
    public boolean manageProcessor(NamedNode definition) {
        return false;
    }

    @Override
    public void manageObject(Object managedObject) throws Exception {
    }

    @Override
    public void unmanageObject(Object managedObject) throws Exception {
    }

    @Override
    public boolean isManaged(Object managedObject) {
        return false;
    }

    @Override
    public boolean isManagedName(Object name) {
        return false;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void notify(CamelEvent event) throws Exception {
        if (!this.eventNotifiers.isEmpty()) {
            for (EventNotifier notifier : this.eventNotifiers) {
                if (!notifier.isEnabled(event)) continue;
                notifier.notify(event);
            }
        }
    }

    @Override
    protected void doInit() throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "CamelContext", this);
        if (!this.getEventNotifiers().isEmpty()) {
            this.getCamelContext().adapt(ExtendedCamelContext.class).setEventNotificationApplicable(true);
        }
        for (EventNotifier notifier : this.eventNotifiers) {
            if (!(notifier instanceof CamelContextAware)) continue;
            CamelContextAware aware = (CamelContextAware)((Object)notifier);
            aware.setCamelContext(this.camelContext);
        }
        ServiceHelper.initService(this.eventNotifiers, this.managementAgent);
        if (this.managementObjectStrategy == null) {
            this.managementObjectStrategy = this.createManagementObjectStrategy();
        }
        if (this.managementObjectStrategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.managementObjectStrategy)).setCamelContext(this.getCamelContext());
        }
        if (this.managementObjectNameStrategy == null) {
            this.managementObjectNameStrategy = this.createManagementObjectNameStrategy();
        }
        if (this.managementObjectNameStrategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.managementObjectNameStrategy)).setCamelContext(this.getCamelContext());
        }
        ServiceHelper.initService(this.managementObjectStrategy, this.managementObjectNameStrategy);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.eventNotifiers, this.managementAgent, this.managementObjectStrategy, this.managementObjectNameStrategy);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.managementObjectNameStrategy, this.managementObjectStrategy, this.managementAgent, this.eventNotifiers);
    }

    protected ManagementObjectNameStrategy createManagementObjectNameStrategy(String domain) {
        return null;
    }

    protected ManagementObjectStrategy createManagementObjectStrategy() {
        return null;
    }

    protected ManagementObjectNameStrategy createManagementObjectNameStrategy() {
        String domain = this.managementAgent != null ? this.managementAgent.getMBeanObjectDomainName() : null;
        return this.createManagementObjectNameStrategy(domain);
    }
}

