/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PooledExchange;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.support.DefaultPooledExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PooledExchangeFactory
extends PrototypeExchangeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PooledExchangeFactory.class);
    private final ReleaseOnDoneTask onDone = new ReleaseOnDoneTask();

    public PooledExchangeFactory() {
    }

    public PooledExchangeFactory(Consumer consumer) {
        super(consumer);
    }

    @Override
    protected void doBuild() throws Exception {
        super.doBuild();
        DefaultPooledExchange dummy = new DefaultPooledExchange(this.camelContext);
        dummy.getIn();
        dummy.getIn().getHeaders();
        LOG.trace("Warming up PooledExchangeFactory loaded class: {}", (Object)dummy.getClass().getName());
    }

    @Override
    public ExchangeFactory newExchangeFactory(Consumer consumer) {
        PooledExchangeFactory answer = new PooledExchangeFactory(consumer);
        answer.setCamelContext(this.camelContext);
        answer.setCapacity(this.capacity);
        answer.setStatisticsEnabled(this.statisticsEnabled);
        return answer;
    }

    @Override
    public Exchange create(boolean autoRelease) {
        Exchange exchange = (Exchange)this.pool.poll();
        if (exchange == null) {
            exchange = this.createPooledExchange(null, autoRelease);
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
        } else {
            if (this.statisticsEnabled) {
                this.statistics.acquired.increment();
            }
            PooledExchange ee = exchange.adapt(PooledExchange.class);
            ee.reset(System.currentTimeMillis());
        }
        return exchange;
    }

    @Override
    public Exchange create(Endpoint fromEndpoint, boolean autoRelease) {
        Exchange exchange = (Exchange)this.pool.poll();
        if (exchange == null) {
            exchange = new DefaultPooledExchange(fromEndpoint);
            if (this.statisticsEnabled) {
                this.statistics.created.increment();
            }
        } else {
            if (this.statisticsEnabled) {
                this.statistics.acquired.increment();
            }
            PooledExchange ee = exchange.adapt(PooledExchange.class);
            ee.reset(System.currentTimeMillis());
        }
        return exchange;
    }

    @Override
    public boolean release(Exchange exchange) {
        try {
            PooledExchange ee = exchange.adapt(PooledExchange.class);
            boolean force = !ee.isAutoRelease();
            ee.done(force);
            ee.onDone(null);
            boolean inserted = this.pool.offer(exchange);
            if (this.statisticsEnabled) {
                if (inserted) {
                    this.statistics.released.increment();
                } else {
                    this.statistics.discarded.increment();
                }
            }
            return inserted;
        }
        catch (Exception e) {
            if (this.statisticsEnabled) {
                this.statistics.discarded.increment();
            }
            LOG.debug("Error resetting exchange: {}. This exchange is discarded.", (Object)exchange);
            return false;
        }
    }

    protected PooledExchange createPooledExchange(Endpoint fromEndpoint, boolean autoRelease) {
        DefaultPooledExchange answer = fromEndpoint != null ? new DefaultPooledExchange(fromEndpoint) : new DefaultPooledExchange(this.camelContext);
        answer.setAutoRelease(autoRelease);
        if (autoRelease) {
            answer.onDone(this.onDone);
        }
        return answer;
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.exchangeFactoryManager != null) {
            this.exchangeFactoryManager.removeExchangeFactory(this);
        }
        if (this.pool != null) {
            this.logUsageSummary(LOG, "PooledExchangeFactory", this.pool.size());
            this.pool.clear();
        }
    }

    private final class ReleaseOnDoneTask
    implements PooledExchange.OnDoneTask {
        private ReleaseOnDoneTask() {
        }

        @Override
        public void onDone(Exchange exchange) {
            PooledExchangeFactory.this.release(exchange);
        }
    }
}

