/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StartupStep;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.ChildServiceSupport;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.MDC;

public class RouteService
extends ChildServiceSupport {
    private final CamelContext camelContext;
    private final StartupStepRecorder startupStepRecorder;
    private final Route route;
    private boolean removingRoutes;
    private Consumer input;
    private final AtomicBoolean setUpDone = new AtomicBoolean();
    private final AtomicBoolean warmUpDone = new AtomicBoolean();
    private final AtomicBoolean endpointDone = new AtomicBoolean();

    public RouteService(Route route) {
        this.route = route;
        this.camelContext = this.route.getCamelContext();
        this.startupStepRecorder = this.camelContext.adapt(ExtendedCamelContext.class).getStartupStepRecorder();
    }

    public String getId() {
        return this.route.getId();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Route getRoute() {
        return this.route;
    }

    public Set<Endpoint> gatherEndpoints() {
        LinkedHashSet<Endpoint> answer = new LinkedHashSet<Endpoint>();
        Set<Service> services = this.gatherChildServices();
        for (Service service : services) {
            Endpoint endpoint;
            if (!(service instanceof EndpointAware) || (endpoint = ((EndpointAware)((Object)service)).getEndpoint()) == null) continue;
            answer.add(endpoint);
        }
        return answer;
    }

    public Consumer getInput() {
        return this.input;
    }

    public boolean isRemovingRoutes() {
        return this.removingRoutes;
    }

    public void setRemovingRoutes(boolean removingRoutes) {
        this.removingRoutes = removingRoutes;
    }

    public void warmUp() throws FailedToStartRouteException {
        try {
            this.doWarmUp();
        }
        catch (Exception e) {
            throw new FailedToStartRouteException(this.getId(), this.route.getDescription(), e);
        }
    }

    public void setUp() throws FailedToStartRouteException {
        if (this.setUpDone.compareAndSet(false, true)) {
            try {
                this.doSetup();
            }
            catch (Exception e) {
                throw new FailedToStartRouteException(this.getId(), this.route.getDescription(), e);
            }
        }
    }

    public boolean isAutoStartup() {
        if (!this.getCamelContext().isAutoStartup().booleanValue()) {
            return false;
        }
        return this.getRoute().isAutoStartup();
    }

    protected synchronized void doSetup() throws Exception {
        ServiceHelper.initService((Object)this.route.getEndpoint());
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.route.initializeServices();
            List<Service> services = this.route.getServices();
            ArrayList<Service> list = new ArrayList<Service>();
            for (Service service : services) {
                if (service instanceof RouteAware) {
                    ((RouteAware)((Object)service)).setRoute(this.route);
                }
                if (service instanceof RouteIdAware) {
                    ((RouteIdAware)((Object)service)).setRouteId(this.route.getId());
                }
                if (service instanceof CamelContextAware) {
                    ((CamelContextAware)((Object)service)).setCamelContext(this.camelContext);
                }
                if (service instanceof Consumer) {
                    this.input = (Consumer)service;
                    continue;
                }
                list.add(service);
            }
            this.initChildServices(list);
        }
    }

    protected synchronized void doWarmUp() throws Exception {
        if (this.endpointDone.compareAndSet(false, true)) {
            ServiceHelper.startService((Object)this.route.getEndpoint());
        }
        if (this.warmUpDone.compareAndSet(false, true)) {
            try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
                this.route.warmUp();
                this.startChildServices(this.route, this.childServices);
                EventHelper.notifyRouteAdded(this.camelContext, this.route);
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesAdd(Collections.singletonList(this.route));
            }
            this.camelContext.adapt(ExtendedCamelContext.class).addRoute(this.route);
            this.camelContext.getInflightRepository().addRoute(this.route.getId());
        }
    }

    @Override
    protected void doStart() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            EventHelper.notifyRouteStarting(this.camelContext, this.route);
        }
        try {
            this.warmUp();
        }
        catch (FailedToStartRouteException e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
        mdcHelper = new MDCHelper(this.route.getId());
        var2_3 = null;
        try {
            ServiceHelper.startService((Object)this.route);
            this.routePolicyCallback(RoutePolicy::onStart);
            EventHelper.notifyRouteStarted(this.camelContext, this.route);
        }
        catch (Throwable throwable) {
            var2_3 = throwable;
            throw throwable;
        }
        finally {
            if (mdcHelper != null) {
                if (var2_3 != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable) {
                        var2_3.addSuppressed(throwable);
                    }
                } else {
                    mdcHelper.close();
                }
            }
        }
    }

    @Override
    protected void doStop() {
        MDCHelper mdcHelper = new MDCHelper(this.route.getId());
        Object object = null;
        try {
            EventHelper.notifyRouteStopping(this.camelContext, this.route);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (mdcHelper != null) {
                if (object != null) {
                    try {
                        mdcHelper.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    mdcHelper.close();
                }
            }
        }
        boolean isShutdownCamelContext = this.camelContext.isStopping();
        if (isShutdownCamelContext || this.isRemovingRoutes()) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onRoutesRemove(Collections.singletonList(this.route));
            }
        }
        try (MDCHelper mdcHelper2 = new MDCHelper(this.route.getId());){
            Set<Service> services = this.gatherChildServices();
            this.stopChildServices(this.route, services, isShutdownCamelContext);
            if (isShutdownCamelContext) {
                ServiceHelper.stopAndShutdownServices(this.route);
            } else {
                ServiceHelper.stopService((Object)this.route);
            }
            this.routePolicyCallback(RoutePolicy::onStop);
            EventHelper.notifyRouteStopped(this.camelContext, this.route);
        }
        if (this.isRemovingRoutes()) {
            this.camelContext.adapt(ExtendedCamelContext.class).removeRoute(this.route);
        }
        this.input = null;
        this.childServices = null;
        this.warmUpDone.set(false);
        this.setUpDone.set(false);
        this.endpointDone.set(false);
        this.setUpDone.set(false);
        this.warmUpDone.set(false);
    }

    @Override
    protected void doShutdown() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            Set<Service> services = this.gatherChildServices();
            this.stopChildServices(this.route, services, true);
            ServiceHelper.stopAndShutdownServices(this.route);
            ServiceHelper.stopAndShutdownServices(this.route.getEndpoint());
            this.routePolicyCallback(RoutePolicy::onRemove);
            EventHelper.notifyRouteRemoved(this.camelContext, this.route);
        }
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRoutesRemove(Collections.singletonList(this.route));
        }
        this.camelContext.getInflightRepository().removeRoute(this.route.getId());
        this.camelContext.adapt(ExtendedCamelContext.class).removeRoute(this.route);
        this.input = null;
        this.childServices = null;
        this.warmUpDone.set(false);
        this.setUpDone.set(false);
        this.endpointDone.set(false);
    }

    @Override
    protected void doSuspend() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.routePolicyCallback(RoutePolicy::onSuspend);
        }
    }

    @Override
    protected void doResume() {
        try (MDCHelper mdcHelper = new MDCHelper(this.route.getId());){
            this.routePolicyCallback(RoutePolicy::onResume);
        }
    }

    private void routePolicyCallback(BiConsumer<RoutePolicy, Route> callback) {
        if (this.route.getRoutePolicyList() != null) {
            for (RoutePolicy routePolicy : this.route.getRoutePolicyList()) {
                callback.accept(routePolicy, this.route);
            }
        }
    }

    private StartupStep beginStep(Service service, String description) {
        Class type = service instanceof Processor ? Processor.class : Service.class;
        description = description + " " + service.getClass().getSimpleName();
        String id = null;
        if (service instanceof IdAware) {
            id = ((IdAware)((Object)service)).getId();
        }
        return this.startupStepRecorder.beginStep(type, id, description);
    }

    protected void initChildServices(List<Service> services) {
        for (Service service : services) {
            boolean record;
            StartupStep step = null;
            boolean bl = record = !(service instanceof InternalProcessor) && !"RoutePipeline".equals(service.getClass().getSimpleName());
            if (record) {
                step = this.beginStep(service, "Init");
            }
            ServiceHelper.initService((Object)service);
            if (step != null) {
                this.startupStepRecorder.endStep(step);
            }
            this.addChildService(service);
        }
    }

    protected void startChildServices(Route route, List<Service> services) {
        for (Service service : services) {
            boolean record;
            StartupStep step = null;
            boolean bl = record = !(service instanceof InternalProcessor) && !"RoutePipeline".equals(service.getClass().getSimpleName());
            if (record) {
                step = this.beginStep(service, "Start");
            }
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceAdd(this.camelContext, service, route);
            }
            ServiceHelper.startService((Object)service);
            if (step == null) continue;
            this.startupStepRecorder.endStep(step);
        }
    }

    protected void stopChildServices(Route route, Set<Service> services, boolean shutdown) {
        for (Service service : services) {
            for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
                strategy.onServiceRemove(this.camelContext, service, route);
            }
            if (shutdown) {
                ServiceHelper.stopAndShutdownService(service);
            } else {
                ServiceHelper.stopService((Object)service);
            }
            this.removeChildService(service);
        }
    }

    private Set<Service> gatherChildServices() {
        ArrayList<Service> services = new ArrayList<Service>(this.route.getServices());
        this.doGetRouteServices(services);
        LinkedHashSet<Service> list = new LinkedHashSet<Service>();
        for (Service service : services) {
            list.addAll(ServiceHelper.getChildServices(service));
        }
        this.doGetErrorHandler(list);
        return list;
    }

    private void doGetErrorHandler(Set<Service> services) {
        ArrayList<Service> extra = new ArrayList<Service>();
        for (Service service : services) {
            Processor eh;
            if (!(service instanceof Channel) || !((eh = ((Channel)((Object)service)).getErrorHandler()) instanceof Service)) continue;
            extra.add((Service)((Object)eh));
        }
        if (!extra.isEmpty()) {
            services.addAll(extra);
        }
    }

    protected void doGetRouteServices(List<Service> services) {
        for (Processor proc : this.getRoute().getOnExceptions()) {
            if (!(proc instanceof Service)) continue;
            services.add((Service)((Object)proc));
        }
        for (Processor proc : this.getRoute().getOnCompletions()) {
            if (!(proc instanceof Service)) continue;
            services.add((Service)((Object)proc));
        }
    }

    class MDCHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;

        MDCHelper(String routeId) {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)RouteService.this.getCamelContext().getName());
                MDC.put((String)"camel.routeId", (String)routeId);
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (RouteService.this.getCamelContext().isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
        }
    }
}

