/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ordering.OrderBy;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.FPException;
import net.sf.flatpack.util.FPInvalidUsageException;
import net.sf.flatpack.util.FPStringUtils;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;

public class DefaultDataSet
implements DataSet {
    private final List rows = new ArrayList();
    private final List errors = new ArrayList();
    private Properties pzConvertProps = null;
    private int pointer = -1;
    private boolean lowerCase = false;
    private boolean upperCase = false;
    private boolean strictNumericParse = false;
    private MetaData metaData;
    private Parser parser;

    public DefaultDataSet(MetaData pzMetaData, Parser pzparser) {
        this.metaData = pzMetaData;
        this.parser = pzparser;
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addError(DataError dataError) {
        this.errors.add(dataError);
    }

    public String[] getColumns() {
        ColumnMetaData column = null;
        String[] array = null;
        if (this.metaData != null) {
            List cmds = this.metaData.getColumnsNames();
            array = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                column = (ColumnMetaData)cmds.get(i);
                array[i] = column.getColName();
            }
        }
        return array;
    }

    public String[] getColumns(String recordID) {
        String[] array = null;
        if (this.metaData != null) {
            List cmds = ParserUtils.getColumnMetaData(recordID, this.metaData);
            array = new String[cmds.size()];
            for (int i = 0; i < cmds.size(); ++i) {
                ColumnMetaData column = (ColumnMetaData)cmds.get(i);
                array[i] = column.getColName();
            }
        }
        return array;
    }

    public Date getDate(String column) throws ParseException {
        return this.getDate(column, new SimpleDateFormat("yyyyMMdd"));
    }

    public Date getDate(String column, SimpleDateFormat sdf) throws ParseException {
        String s = this.getStringValue(column);
        if (FPStringUtils.isBlank(s)) {
            return null;
        }
        return sdf.parse(s);
    }

    public double getDouble(String column) {
        StringBuffer newString = new StringBuffer();
        String s = this.getStringValue(column);
        if (!this.strictNumericParse) {
            newString.append(ParserUtils.stripNonDoubleChars(s));
        } else {
            newString.append(s);
        }
        return Double.parseDouble(newString.toString());
    }

    public BigDecimal getBigDecimal(String column) {
        String s = this.getStringValue(column);
        return new BigDecimal(s);
    }

    private String getStringValue(String column) {
        Row row = (Row)this.rows.get(this.pointer);
        return row.getValue(ParserUtils.getColumnIndex(row.getMdkey(), this.metaData, column, this.parser));
    }

    public Object getObject(String column, Class classToConvertTo) {
        String s = this.getStringValue(column);
        return ParserUtils.runPzConverter(this.pzConvertProps, s, classToConvertTo);
    }

    public int getErrorCount() {
        if (this.getErrors() != null) {
            return this.getErrors().size();
        }
        return 0;
    }

    public List getErrors() {
        return this.errors;
    }

    public int getIndex() {
        return this.pointer;
    }

    public int getInt(String column) {
        String s = this.getStringValue(column);
        if (!this.strictNumericParse) {
            return Integer.parseInt(ParserUtils.stripNonLongChars(s));
        }
        return Integer.parseInt(s);
    }

    public long getLong(String column) {
        String s = this.getStringValue(column);
        if (!this.strictNumericParse) {
            return Long.parseLong(ParserUtils.stripNonLongChars(s));
        }
        return Long.parseLong(s);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getRowNo() {
        return ((Row)this.rows.get(this.pointer)).getRowNumber();
    }

    public String getString(String column) {
        String s = this.getStringValue(column);
        if (this.parser.isNullEmptyStrings() && FPStringUtils.isBlank(s)) {
            s = null;
        } else if (this.upperCase) {
            s = s.toUpperCase(Locale.getDefault());
        } else if (this.lowerCase) {
            s = s.toLowerCase(Locale.getDefault());
        }
        return s;
    }

    public void setValue(String column, String value) {
        Row row = (Row)this.rows.get(this.pointer);
        int colIndex = ParserUtils.getColumnIndex(row.getMdkey(), this.metaData, column, this.parser);
        row.setValue(colIndex, value);
    }

    public void goBottom() {
        this.pointer = this.rows.size() - 1;
    }

    public void goTop() {
        this.pointer = -1;
    }

    public boolean isAnError(int lineNo) {
        for (int i = 0; i < this.errors.size(); ++i) {
            if (((DataError)this.errors.get(i)).getLineNo() != lineNo || ((DataError)this.errors.get(i)).getErrorLevel() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.pointer < this.rows.size() && this.pointer + 1 != this.rows.size()) {
            ++this.pointer;
            return true;
        }
        return false;
    }

    public void orderRows(OrderBy ob) {
        if (ob != null && this.rows != null) {
            List cmds = this.metaData.getColumnsNames();
            ob.setMetaData(this.getMetaData());
            ob.setParser(this.parser);
            Collections.sort(this.rows, ob);
            this.goTop();
        }
    }

    public boolean previous() {
        if (this.pointer <= 0) {
            return false;
        }
        --this.pointer;
        return true;
    }

    public void setLowerCase() {
        this.upperCase = false;
        this.lowerCase = true;
    }

    public void setUpperCase() {
        this.upperCase = true;
        this.lowerCase = false;
    }

    public boolean isRecordID(String recordID) {
        String rowID = ((Row)this.rows.get(this.pointer)).getMdkey();
        if (rowID == null) {
            rowID = "detail";
        }
        return rowID.equals(recordID);
    }

    public void absolute(int localPointer) {
        if (localPointer < 0 || localPointer > this.rows.size() - 1) {
            throw new IndexOutOfBoundsException("INVALID POINTER LOCATION: " + localPointer);
        }
        this.pointer = localPointer;
    }

    public void setStrictNumericParse(boolean strictNumericParse) {
        this.strictNumericParse = strictNumericParse;
    }

    public void remove() {
        this.rows.remove(this.pointer);
        --this.pointer;
    }

    public void setPZConvertProps(Properties props) {
        this.pzConvertProps = props;
    }

    protected void setPointer(int pointer) {
        this.pointer = pointer;
    }

    public void clearRows() {
        this.pointer = -1;
        this.rows.clear();
    }

    public void clearAll() {
        this.clearRows();
        this.clearErrors();
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Errors:").append(this.errors.size()).append(System.getProperty("line.separator"));
        buf.append("Rows:").append(this.rows.size()).append(System.getProperty("line.separator"));
        buf.append("Position:").append(this.pointer).append(System.getProperty("line.separator"));
        buf.append("Conversion Props:").append(this.pzConvertProps).append(System.getProperty("line.separator"));
        buf.append("MetaData:").append(this.metaData).append(System.getProperty("line.separator"));
        return buf.toString();
    }

    public boolean contains(String column) {
        if (this.pointer == -1) {
            throw new IndexOutOfBoundsException("dataset on invalid row. need to call next()");
        }
        Iterator cmds = ParserUtils.getColumnMetaData(((Row)this.rows.get(this.pointer)).getMdkey(), this.metaData).iterator();
        while (cmds.hasNext()) {
            ColumnMetaData cmd = (ColumnMetaData)cmds.next();
            if (!cmd.getColName().equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    public boolean isRowEmpty() {
        if (!this.parser.isFlagEmptyRows()) {
            throw new FPInvalidUsageException("Parser.isFlagEmptyRows(true) must be set before using isRowEmpty()");
        }
        if (this.pointer < 0) {
            throw new FPException("Cursor on invalid row..  Make sure next() is called and returns true");
        }
        return ((Row)this.rows.get(this.pointer)).isEmpty();
    }

    public String getRawData() {
        if (!this.parser.isStoreRawDataToDataSet()) {
            throw new FPInvalidUsageException("Parser.isStoreRawDataToDataSet(true) must be set before using getRawData()");
        }
        if (this.pointer < 0) {
            throw new FPException("Cursor on invalid row.. Make sure next() is called and returns true");
        }
        return ((Row)this.rows.get(this.pointer)).getRawData();
    }
}

