/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.brparse;

import java.io.IOException;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.brparse.BuffReaderDelimParser;
import net.sf.flatpack.brparse.BuffReaderFixedParser;
import net.sf.flatpack.ordering.OrderBy;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.xml.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuffReaderDataSet
extends DefaultDataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger((Class)BuffReaderDataSet.class);
    private final BuffReaderDelimParser brDelimPzParser;
    private final BuffReaderFixedParser brFixedPzParser;

    public BuffReaderDataSet(MetaData columnMD2, BuffReaderDelimParser brDelimPzParser) {
        super(columnMD2, brDelimPzParser);
        this.brDelimPzParser = brDelimPzParser;
        this.brFixedPzParser = null;
    }

    public BuffReaderDataSet(MetaData columnMD2, BuffReaderFixedParser brFixedPzParser) {
        super(columnMD2, brFixedPzParser);
        this.brFixedPzParser = brFixedPzParser;
        this.brDelimPzParser = null;
    }

    public boolean next() {
        try {
            Row r = null;
            if (this.brDelimPzParser != null) {
                r = this.brDelimPzParser.buildRow(this);
            } else if (this.brFixedPzParser != null) {
                r = this.brFixedPzParser.buildRow(this);
            } else {
                throw new RuntimeException("No parser available to fetch row");
            }
            if (r == null) {
                this.setPointer(-1);
                return false;
            }
            if (this.getMetaData() == null) {
                this.setMetaData(this.brDelimPzParser.getPzMetaData());
            }
            this.clearRows();
            this.addRow(r);
            this.setPointer(0);
            return true;
        }
        catch (IOException ex) {
            LOGGER.error("error building Row on next()", (Throwable)ex);
            return false;
        }
    }

    public boolean previous() {
        throw new UnsupportedOperationException("previous() is Not Implemented");
    }

    public void orderRows(OrderBy ob) {
        throw new UnsupportedOperationException("orderRows() is Not Implemented");
    }

    public void absolute(int localPointer) {
        throw new UnsupportedOperationException("absolute() is Not Implemented");
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is Not Implemented");
    }

    public int getIndex() {
        throw new UnsupportedOperationException("getIndex() is Not Implemented");
    }

    public void goBottom() {
        throw new UnsupportedOperationException("goBottom() is Not Implemented");
    }

    public void goTop() {
        throw new UnsupportedOperationException("goTop() is Not Implemented");
    }

    public void setValue(String column, String value) {
        throw new UnsupportedOperationException("setValue() is Not Implemented");
    }

    public int getRowCount() {
        throw new UnsupportedOperationException("getRowCount() is Not Implemented");
    }
}

