/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.brparse;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.DelimiterParser;
import net.sf.flatpack.brparse.BuffReaderDataSet;
import net.sf.flatpack.structure.Row;
import net.sf.flatpack.util.ParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuffReaderDelimParser
extends DelimiterParser {
    private BufferedReader br;
    private boolean processedFirst = false;
    private final Logger logger = LoggerFactory.getLogger((Class)BuffReaderDelimParser.class);

    public BuffReaderDelimParser(File pzmapXML, File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(pzmapXML, dataSource, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(InputStream pzmapXMLStream, InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(pzmapXMLStream, dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSource, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(Reader pzmapXML, Reader dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSource, pzmapXML, delimiter, qualifier, ignoreFirstRecord);
    }

    public BuffReaderDelimParser(Reader dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceStream, delimiter, qualifier, ignoreFirstRecord);
    }

    protected DataSet doParse() {
        BuffReaderDataSet ds = new BuffReaderDataSet(this.getPzMetaData(), this);
        try {
            ds.setPZConvertProps(ParserUtils.loadConvertProperties());
            this.br = new BufferedReader(this.getDataSourceReader());
            return ds;
        }
        catch (IOException ex) {
            this.logger.error("error accessing/creating inputstream", (Throwable)ex);
            return null;
        }
    }

    public Row buildRow(DefaultDataSet ds) throws IOException {
        String mdkey;
        List<String> columns;
        String line;
        while (true) {
            if ((line = this.fetchNextRecord(this.br, this.getQualifier(), this.getDelimiter())) == null) {
                return null;
            }
            if (!this.processedFirst && this.isIgnoreFirstRecord()) {
                this.processedFirst = true;
                continue;
            }
            if (!this.processedFirst && this.shouldCreateMDFromFile()) {
                this.processedFirst = true;
                this.setPzMetaData(ParserUtils.getPZMetaDataFromFile(line, this.getDelimiter(), this.getQualifier(), this));
                continue;
            }
            columns = ParserUtils.splitLine(line, this.getDelimiter(), this.getQualifier(), 10);
            mdkey = ParserUtils.getCMDKeyForDelimitedFile(this.getPzMetaData(), (List)columns);
            List cmds = ParserUtils.getColumnMetaData(mdkey, this.getPzMetaData());
            int columnCount = cmds.size();
            if (columns.size() > columnCount) {
                if (this.isIgnoreExtraColumns()) {
                    columns = columns.subList(0, columnCount);
                    this.addError(ds, "TRUNCATED LINE TO CORRECT NUMBER OF COLUMNS", this.getLineCount(), 1);
                    break;
                }
                this.addError(ds, "TOO MANY COLUMNS WANTED: " + columnCount + " GOT: " + columns.size(), this.getLineCount(), 2, this.isStoreRawDataToDataError() ? line : null);
                continue;
            }
            if (columns.size() >= columnCount) break;
            if (this.isHandlingShortLines()) {
                while (columns.size() < columnCount) {
                    columns.add("");
                }
                this.addError(ds, "PADDED LINE TO CORRECT NUMBER OF COLUMNS", this.getLineCount(), 1);
                break;
            }
            this.addError(ds, "TOO FEW COLUMNS WANTED: " + columnCount + " GOT: " + columns.size(), this.getLineCount(), 2, this.isStoreRawDataToDataError() ? line : null);
        }
        Row row = new Row();
        row.setMdkey(mdkey.equals("detail") ? null : mdkey);
        row.setCols(columns);
        row.setRowNumber(this.getLineCount());
        if (this.isFlagEmptyRows()) {
            row.setEmpty(ParserUtils.isListElementsEmpty(columns));
        }
        if (this.isStoreRawDataToDataSet()) {
            row.setRawData(line);
        }
        return row;
    }

    public void close() throws IOException {
        if (this.br != null) {
            this.br.close();
            this.br = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException ex) {
            this.logger.warn("Problem trying to auto close file handles...", (Throwable)ex);
        }
        finally {
            super.finalize();
        }
    }
}

