/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.flatpack.writer.Writer;

public abstract class AbstractWriter
implements Writer {
    private BufferedWriter writer;
    private Map rowMap;

    public AbstractWriter(java.io.Writer output) {
        this.writer = new BufferedWriter(output);
    }

    public void addRecordEntry(String columnName, Object value) {
        if (this.rowMap == null) {
            this.rowMap = new HashMap();
        }
        if (!this.validateColumnTitle(columnName)) {
            throw new IllegalArgumentException("unknown column: \"" + columnName + "\"");
        }
        this.rowMap.put(columnName, value);
    }

    protected abstract boolean validateColumnTitle(String var1);

    public void nextRecord() throws IOException {
        this.rowMap = null;
        this.writer.newLine();
    }

    protected void write(Object value) throws IOException {
        if (value == null) {
            value = "";
        }
        this.writer.write(value.toString());
    }

    protected void write(char character) throws IOException {
        this.writer.write(character);
    }

    protected void write(char[] characters) throws IOException {
        this.writer.write(characters);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected Map getRowMap() {
        return this.rowMap;
    }
}

