/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.writer.AbstractWriter;

public class DelimiterWriter
extends AbstractWriter {
    private char delimiter;
    private char qualifier;
    private List columnTitles = null;
    private boolean columnTitlesWritten = false;

    protected DelimiterWriter(Map columnMapping, Writer output, char delimiter, char qualifier) throws IOException {
        super(output);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.columnTitles = new ArrayList();
        List columns = (List)columnMapping.get("detail");
        Iterator columnIter = columns.iterator();
        while (columnIter.hasNext()) {
            ColumnMetaData element = (ColumnMetaData)columnIter.next();
            this.columnTitles.add(element.getColName());
        }
        this.nextRecord();
    }

    protected void writeWithDelimiter(Object value) throws IOException {
        this.write(value);
        this.write(this.delimiter);
    }

    protected void write(Object value) throws IOException {
        boolean needsQuoting;
        String stringValue = "";
        if (value != null) {
            stringValue = value.toString();
        }
        boolean bl = needsQuoting = stringValue.indexOf(this.delimiter) != -1;
        if (needsQuoting) {
            super.write(this.qualifier);
        }
        super.write(stringValue);
        if (needsQuoting) {
            super.write(this.qualifier);
        }
    }

    protected void addColumnTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("column title may not be null");
        }
        this.columnTitles.add(string);
    }

    protected void writeColumnTitles() throws IOException {
        Iterator titleIter = this.columnTitles.iterator();
        while (titleIter.hasNext()) {
            String title = (String)titleIter.next();
            if (titleIter.hasNext()) {
                this.writeWithDelimiter(title);
                continue;
            }
            this.write(title);
        }
    }

    protected void writeRow() throws IOException {
        Iterator titlesIter = this.columnTitles.iterator();
        while (titlesIter.hasNext()) {
            String columnTitle = (String)titlesIter.next();
            if (titlesIter.hasNext()) {
                this.writeWithDelimiter(this.getRowMap().get(columnTitle));
                continue;
            }
            this.write(this.getRowMap().get(columnTitle));
        }
    }

    public void nextRecord() throws IOException {
        if (!this.columnTitlesWritten) {
            this.writeColumnTitles();
            this.columnTitlesWritten = true;
        } else {
            this.writeRow();
        }
        super.nextRecord();
    }

    public void printFooter() {
    }

    public void printHeader() {
    }

    protected boolean validateColumnTitle(String columnTitle) {
        return this.columnTitles.contains(columnTitle);
    }
}

