/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.writer.AbstractWriterFactory;
import net.sf.flatpack.writer.DelimiterWriter;
import net.sf.flatpack.writer.Writer;
import org.jdom.JDOMException;

public class DelimiterWriterFactory
extends AbstractWriterFactory {
    public static final char DEFAULT_DELIMITER = ';';
    public static final char DEFAULT_QUALIFIER = '\"';
    private final char delimiter;
    private final char qualifier;

    public DelimiterWriterFactory(char delimiter, char qualifier) {
        this.delimiter = delimiter;
        this.qualifier = qualifier;
    }

    public DelimiterWriterFactory(Reader mappingSrc) throws IOException, JDOMException {
        this(mappingSrc, ';');
    }

    public DelimiterWriterFactory(Reader mappingSrc, char delimiter) throws IOException, JDOMException {
        this(mappingSrc, delimiter, '\"');
    }

    public DelimiterWriterFactory(Reader mappingSrc, char delimiter, char qualifier) throws IOException {
        super(mappingSrc);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
    }

    public DelimiterWriterFactory(Map mapping) {
        this(mapping, ';', '\"');
    }

    public DelimiterWriterFactory(Map mapping, char delimiter) {
        this(mapping, delimiter, '\"');
    }

    public DelimiterWriterFactory(Map mapping, char delimiter, char qualifier) {
        super(mapping);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public char getQualifier() {
        return this.qualifier;
    }

    public Writer createWriter(java.io.Writer out) throws IOException {
        return new DelimiterWriter(this.getColumnMapping(), out, this.delimiter, this.qualifier);
    }

    public void addColumnTitle(String columnTitle) {
        Map columnMapping = this.getColumnMapping();
        List columnMetaDatas = (List)columnMapping.get("detail");
        Map columnIndices = (Map)columnMapping.get("colIndex");
        ColumnMetaData metaData = new ColumnMetaData();
        metaData.setColName(columnTitle);
        columnMetaDatas.add(metaData);
        Integer columnIndex = new Integer(columnMetaDatas.indexOf(metaData));
        columnIndices.put(columnIndex, columnTitle);
    }
}

