/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.writer.AbstractWriter;

public class FixedLengthWriter
extends AbstractWriter {
    private static final int MAX_CHAR_TO_USE_LOOP = 8;
    private final Map columnMapping;
    private final char padChar;

    protected FixedLengthWriter(Map parsedMapping, Writer output, char padChar) throws IOException {
        super(output);
        this.columnMapping = parsedMapping;
        this.padChar = padChar;
    }

    public void addRecordEntry(String columnName, Object value) {
        if (value != null) {
            ColumnMetaData metaData = this.getColumnMetaData(columnName);
            String valueString = value.toString();
            if (valueString.length() > metaData.getColLength()) {
                throw new IllegalArgumentException(valueString + " exceeds the maximum length for column " + columnName + "(" + metaData.getColLength() + ")");
            }
        }
        super.addRecordEntry(columnName, value);
    }

    public void nextRecord() throws IOException {
        Iterator columnIter = this.getColumnMetaData().iterator();
        while (columnIter.hasNext()) {
            ColumnMetaData element = (ColumnMetaData)columnIter.next();
            Object value = this.getRowMap().get(element.getColName());
            this.write(this.formattedValue(value, element));
        }
        super.nextRecord();
    }

    protected char[] formattedValue(Object value, ColumnMetaData element) {
        if (value == null) {
            value = "";
        }
        String stringValue = value.toString();
        int stringLength = stringValue.length();
        int columnLength = element.getColLength();
        char[] formattedValue = new char[columnLength];
        int numCharacters = Math.min(stringLength, columnLength);
        if (numCharacters < 8) {
            for (int i = 0; i < numCharacters; ++i) {
                formattedValue[i] = stringValue.charAt(i);
            }
        } else {
            stringValue.getChars(0, numCharacters, formattedValue, 0);
        }
        if (stringLength < columnLength) {
            Arrays.fill(formattedValue, stringLength, columnLength, this.padChar);
        }
        return formattedValue;
    }

    protected boolean validateColumnTitle(String columnTitle) {
        Map columnNameToIndex = (Map)this.columnMapping.get("colIndex");
        return columnNameToIndex.keySet().contains(columnTitle);
    }

    public void printFooter() {
    }

    public void printHeader() {
    }

    private List getColumnMetaData() {
        return (List)this.columnMapping.get("detail");
    }

    private ColumnMetaData getColumnMetaData(String columnName) {
        Iterator metaDataIter = this.getColumnMetaData().iterator();
        while (metaDataIter.hasNext()) {
            ColumnMetaData element = (ColumnMetaData)metaDataIter.next();
            if (!element.getColName().equals(columnName)) continue;
            return element;
        }
        throw new IllegalArgumentException("Column \"" + columnName + "\" unknown");
    }
}

