/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.Parser;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;
import net.sf.flatpack.xml.ResolveLocalDTD;
import net.sf.flatpack.xml.XMLRecordElement;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapParser {
    private static boolean showDebug = false;
    private static final Logger LOGGER = LoggerFactory.getLogger((Class)MapParser.class);

    private MapParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map parse(InputStream xmlStream) throws JDOMException, IOException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(xmlStream);
            Map map = MapParser.parse(isr, null);
            return map;
        }
        finally {
            if (isr != null) {
                isr.close();
            }
        }
    }

    public static Map parse(Reader xmlStreamReader, Parser pzparser) throws JDOMException, IOException {
        if (xmlStreamReader == null) {
            throw new NullPointerException("XML Reader Is Not Allowed To Be Null...");
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(true);
        builder.setEntityResolver(new ResolveLocalDTD());
        Document document = builder.build(xmlStreamReader, "file:///");
        Element root = document.getRootElement();
        List columns = MapParser.getColumnChildren(root);
        LinkedHashMap<String, Object> mdIndex = new LinkedHashMap<String, Object>();
        mdIndex.put("detail", columns);
        mdIndex.put("colIndex", ParserUtils.buidColumnIndexMap(columns, pzparser));
        Iterator recordDescriptors = root.getChildren("RECORD").iterator();
        while (recordDescriptors.hasNext()) {
            Element xmlElement = (Element)recordDescriptors.next();
            if (xmlElement.getAttributeValue("id").equals("detail")) {
                throw new IllegalArgumentException("The ID 'detail' on the <RECORD> element is reserved, please select another id");
            }
            columns = MapParser.getColumnChildren(xmlElement);
            XMLRecordElement xmlre = new XMLRecordElement();
            xmlre.setColumns(columns, pzparser);
            xmlre.setIndicator(xmlElement.getAttributeValue("indicator"));
            xmlre.setElementNumber(MapParser.convertAttributeToInt(xmlElement.getAttribute("elementNumber")));
            xmlre.setStartPosition(MapParser.convertAttributeToInt(xmlElement.getAttribute("startPosition")));
            xmlre.setEndPositition(MapParser.convertAttributeToInt(xmlElement.getAttribute("endPosition")));
            xmlre.setElementCount(MapParser.convertAttributeToInt(xmlElement.getAttribute("elementCount")));
            mdIndex.put(xmlElement.getAttributeValue("id"), xmlre);
        }
        if (showDebug) {
            MapParser.showDebug(mdIndex);
        }
        return mdIndex;
    }

    private static int convertAttributeToInt(Attribute attribute) {
        if (attribute == null) {
            return 0;
        }
        try {
            return attribute.getIntValue();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private static List getColumnChildren(Element parent) {
        ArrayList<ColumnMetaData> columnResults = new ArrayList<ColumnMetaData>();
        HashSet<String> columnNames = new HashSet<String>();
        Iterator xmlChildren = parent.getChildren("COLUMN").iterator();
        while (xmlChildren.hasNext()) {
            ColumnMetaData cmd = new ColumnMetaData();
            Element xmlColumn = (Element)xmlChildren.next();
            String columnName = xmlColumn.getAttributeValue("name");
            if (columnName == null) {
                throw new IllegalArgumentException("Name attribute is required on the column tag!");
            }
            if (columnNames.contains(columnName)) {
                throw new IllegalArgumentException("Duplicate name column '" + columnName + "'");
            }
            cmd.setColName(columnName);
            columnNames.add(columnName);
            if (xmlColumn.getAttributeValue("length") != null) {
                try {
                    cmd.setColLength(Integer.parseInt(xmlColumn.getAttributeValue("length")));
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("LENGTH ATTRIBUTE ON COLUMN ELEMENT MUST BE AN INTEGER.  GOT: " + xmlColumn.getAttributeValue("length"));
                }
            }
            columnResults.add(cmd);
        }
        return columnResults;
    }

    public static void setDebug(boolean b) {
        showDebug = b;
    }

    private static void showDebug(Map xmlResults) {
        Iterator mapIt = xmlResults.entrySet().iterator();
        while (mapIt.hasNext()) {
            XMLRecordElement xmlrecEle = null;
            Map.Entry entry = mapIt.next();
            String recordID = (String)entry.getKey();
            Iterator columns = null;
            if (recordID.equals("detail")) {
                columns = ((List)entry.getValue()).iterator();
            } else {
                xmlrecEle = (XMLRecordElement)entry.getValue();
                columns = xmlrecEle.getColumns().iterator();
            }
            LOGGER.debug(">>>>Column MD Id: " + recordID);
            if (xmlrecEle != null) {
                LOGGER.debug("Start Position: " + xmlrecEle.getStartPosition() + " " + "End Position: " + xmlrecEle.getEndPositition() + " " + "Element Number: " + xmlrecEle.getElementNumber() + " " + "Indicator: " + xmlrecEle.getIndicator());
            }
            while (columns.hasNext()) {
                ColumnMetaData cmd = (ColumnMetaData)columns.next();
                LOGGER.debug("Column Name: " + cmd.getColName() + " LENGTH: " + cmd.getColLength());
            }
        }
    }

    public static MetaData parseMap(Reader xmlStreamReader, Parser pzparser) throws JDOMException, IOException {
        Map map = MapParser.parse(xmlStreamReader, pzparser);
        List col = (List)map.get("detail");
        map.remove("detail");
        Map m = (Map)map.get("colIndex");
        map.remove("colIndex");
        return new MetaData(col, m, map);
    }
}

