/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.xml.XMLRecordElement;

public class MetaData {
    private List columnsNames;
    private Map columnIndexMap;
    private Map xmlRecordElements;

    public MetaData(Map fullMapFromPZParser) {
        this.columnsNames = (List)fullMapFromPZParser.get("detail");
        this.columnIndexMap = (Map)fullMapFromPZParser.get("colIndex");
        this.xmlRecordElements = fullMapFromPZParser;
    }

    public MetaData(List columnNames, Map columnIndexMap) {
        this.columnsNames = Collections.unmodifiableList(columnNames);
        this.columnIndexMap = Collections.unmodifiableMap(columnIndexMap);
        this.xmlRecordElements = new HashMap();
    }

    MetaData(List columnNames, Map columnIndexMap, Map xmlRecordElements) {
        this.columnsNames = Collections.unmodifiableList(columnNames);
        this.columnIndexMap = columnIndexMap;
        this.xmlRecordElements = xmlRecordElements;
    }

    public List getColumnsNames() {
        return this.columnsNames;
    }

    public Map getColumnIndexMap() {
        return this.columnIndexMap;
    }

    public void setColumnIndexMap(Map columnIndexMap) {
        this.columnIndexMap = columnIndexMap;
    }

    public void setColumnsNames(List columnsNames) {
        this.columnsNames = Collections.unmodifiableList(columnsNames);
    }

    public boolean isAnyRecordFormatSpecified() {
        return this.xmlRecordElements != null && !this.xmlRecordElements.isEmpty();
    }

    public Iterator xmlRecordIterator() {
        return this.xmlRecordElements.entrySet().iterator();
    }

    public List getListColumnsForRecord(String key) {
        return ((XMLRecordElement)this.xmlRecordElements.get(key)).getColumns();
    }

    public int getColumnIndex(String key, String columnName) {
        Integer i;
        int idx = -1;
        if (key != null && !key.equals("detail") && !key.equals("colIndex")) {
            idx = ((XMLRecordElement)this.xmlRecordElements.get(key)).getColumnIndex(columnName);
        } else if ((key == null || key.equals("detail")) && (i = (Integer)this.columnIndexMap.get(columnName)) != null) {
            idx = i;
        }
        return idx;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Col Names:").append(this.columnsNames).append(System.getProperty("line.separator"));
        buf.append("Col Index Map:").append(this.columnIndexMap).append(System.getProperty("line.separator"));
        buf.append("XML Record Elements:").append(this.xmlRecordElements).append(System.getProperty("line.separator"));
        return buf.toString();
    }
}

