/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ParserFactory;
import net.sf.flatpack.writer.DelimiterWriterFactory;
import net.sf.flatpack.writer.FixedWriterFactory;
import net.sf.flatpack.writer.Writer;
import org.apache.camel.Exchange;
import org.apache.camel.component.flatpack.DataSetList;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatpackDataFormat
implements DataFormat {
    private static final Logger LOG = LoggerFactory.getLogger(FlatpackDataFormat.class);
    private ParserFactory parserFactory = DefaultParserFactory.getInstance();
    private char delimiter = (char)44;
    private char textQualifier = (char)34;
    private boolean ignoreFirstRecord = true;
    private boolean fixed;
    private boolean allowShortLines;
    private boolean ignoreExtraColumns;
    private String definition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ObjectHelper.notNull((Object)graph, (String)"The object to marshal must be provided");
        List data = (List)graph;
        if (data.isEmpty()) {
            LOG.warn("No data to marshal as the list is empty");
            return;
        }
        Map firstRow = (Map)data.get(0);
        Writer writer = this.createWriter(exchange, firstRow, stream);
        try {
            boolean first = true;
            writer.printHeader();
            for (Map row : data) {
                if (this.ignoreFirstRecord && first) {
                    first = false;
                    continue;
                }
                for (Map.Entry entry : row.entrySet()) {
                    writer.addRecordEntry((String)entry.getKey(), entry.getValue());
                }
                writer.nextRecord();
            }
            writer.printFooter();
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange));
        try {
            Parser parser = this.createParser(exchange, reader);
            DataSet dataSet = parser.parse();
            DataSetList dataSetList = new DataSetList(dataSet);
            return dataSetList;
        }
        finally {
            reader.close();
        }
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public boolean isAllowShortLines() {
        return this.allowShortLines;
    }

    public void setAllowShortLines(boolean allowShortLines) {
        this.allowShortLines = allowShortLines;
    }

    public void setIgnoreExtraColumns(boolean ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
    }

    public boolean isIgnoreExtraColumns() {
        return this.ignoreExtraColumns;
    }

    protected Parser createParser(Exchange exchange, Reader bodyReader) throws IOException {
        if (this.isFixed()) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)exchange.getContext().getClassResolver(), (String)this.getDefinition());
            InputStreamReader reader = new InputStreamReader(is, IOHelper.getCharsetName((Exchange)exchange));
            Parser parser = this.getParserFactory().newFixedLengthParser(reader, bodyReader);
            if (this.allowShortLines) {
                parser.setHandlingShortLines(true);
                parser.setIgnoreParseWarnings(true);
            }
            if (this.ignoreExtraColumns) {
                parser.setIgnoreExtraColumns(true);
                parser.setIgnoreParseWarnings(true);
            }
            return parser;
        }
        if (ObjectHelper.isEmpty((Object)this.getDefinition())) {
            return this.getParserFactory().newDelimitedParser(bodyReader, this.delimiter, this.textQualifier);
        }
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)exchange.getContext().getClassResolver(), (String)this.getDefinition());
        InputStreamReader reader = new InputStreamReader(is, IOHelper.getCharsetName((Exchange)exchange));
        Parser parser = this.getParserFactory().newDelimitedParser(reader, bodyReader, this.delimiter, this.textQualifier, this.ignoreFirstRecord);
        if (this.allowShortLines) {
            parser.setHandlingShortLines(true);
            parser.setIgnoreParseWarnings(true);
        }
        if (this.ignoreExtraColumns) {
            parser.setIgnoreExtraColumns(true);
            parser.setIgnoreParseWarnings(true);
        }
        return parser;
    }

    private Writer createWriter(Exchange exchange, Map<String, Object> firstRow, OutputStream stream) throws JDOMException, IOException {
        if (this.isFixed()) {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)exchange.getContext().getClassResolver(), (String)this.getDefinition());
            InputStreamReader reader = new InputStreamReader(is, IOHelper.getCharsetName((Exchange)exchange));
            FixedWriterFactory factory = new FixedWriterFactory(reader);
            return factory.createWriter(new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange)));
        }
        if (this.getDefinition() == null) {
            DelimiterWriterFactory factory = new DelimiterWriterFactory(this.delimiter, this.textQualifier);
            for (String key : firstRow.keySet()) {
                factory.addColumnTitle(key);
            }
            return factory.createWriter(new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange)));
        }
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)exchange.getContext().getClassResolver(), (String)this.getDefinition());
        InputStreamReader reader = new InputStreamReader(is, IOHelper.getCharsetName((Exchange)exchange));
        DelimiterWriterFactory factory = new DelimiterWriterFactory(reader, this.delimiter, this.textQualifier);
        return factory.createWriter(new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange)));
    }
}

