/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultDataSet;
import net.sf.flatpack.Parser;
import net.sf.flatpack.Record;
import net.sf.flatpack.StreamingDataSet;
import net.sf.flatpack.StreamingRecord;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.ParserUtils;
import net.sf.flatpack.xml.MetaData;

public abstract class AbstractParser
implements Parser {
    private boolean handlingShortLines = false;
    private boolean ignoreExtraColumns = false;
    private boolean preserveLeadingWhitespace = true;
    private boolean preserveTrailingWhitespace = false;
    private boolean columnNamesCaseSensitive = false;
    private boolean initialised = false;
    private boolean ignoreParseWarnings = false;
    private boolean nullEmptyStrings = false;
    private MetaData pzMetaData = null;
    private String dataDefinition = null;
    private Reader dataSourceReader = null;
    private List<Reader> readersToClose = null;
    private boolean flagEmptyRows;
    private boolean storeRawDataToDataError;
    private boolean storeRawDataToDataSet;
    private String dataFileTable = "DATAFILE";
    private String dataStructureTable = "DATASTRUCTURE";
    private boolean addSuffixToDuplicateColumnNames = false;

    public boolean isAddSuffixToDuplicateColumnNames() {
        return this.addSuffixToDuplicateColumnNames;
    }

    @Override
    public Parser setAddSuffixToDuplicateColumnNames(boolean addSuffixToDuplicateColumnNames) {
        this.addSuffixToDuplicateColumnNames = addSuffixToDuplicateColumnNames;
        return this;
    }

    protected AbstractParser(Reader dataSourceReader) {
        this.dataSourceReader = dataSourceReader;
    }

    protected AbstractParser(Reader dataSourceReader, String dataDefinition) {
        this.dataSourceReader = dataSourceReader;
        this.dataDefinition = dataDefinition;
    }

    protected void initStreamOrSource(InputStream dataSourceStream, File dataSource) throws FileNotFoundException {
        if (dataSourceStream != null) {
            InputStreamReader r = new InputStreamReader(dataSourceStream);
            this.setDataSourceReader(r);
            this.addToCloseReaderList(r);
        } else if (dataSource != null) {
            FileReader r = new FileReader(dataSource);
            this.setDataSourceReader(r);
            this.addToCloseReaderList(r);
        }
    }

    @Override
    public boolean isHandlingShortLines() {
        return this.handlingShortLines;
    }

    @Override
    public Parser setHandlingShortLines(boolean handleShortLines) {
        this.handlingShortLines = handleShortLines;
        return this;
    }

    @Override
    public boolean isIgnoreExtraColumns() {
        return this.ignoreExtraColumns;
    }

    @Override
    public Parser setIgnoreExtraColumns(boolean ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
        return this;
    }

    @Override
    public boolean isPreserveLeadingWhitespace() {
        return this.preserveLeadingWhitespace;
    }

    @Override
    public Parser setPreserveLeadingWhitespace(boolean preserveLeadingWhitespace) {
        this.preserveLeadingWhitespace = preserveLeadingWhitespace;
        return this;
    }

    @Override
    public boolean isPreserveTrailingWhitespace() {
        return this.preserveTrailingWhitespace;
    }

    @Override
    public Parser setPreserveTrailingWhitespace(boolean preserveTrailingWhitespace) {
        this.preserveTrailingWhitespace = preserveTrailingWhitespace;
        return this;
    }

    @Override
    public final DataSet parse() {
        if (!this.initialised) {
            this.init();
        }
        return this.doParse();
    }

    @Override
    public final StreamingDataSet parseAsStream() {
        return new StreamingRecord(this.parse());
    }

    @Override
    public final Stream<Record> stream() {
        return new StreamingRecord(this.parse()).stream();
    }

    protected abstract DataSet doParse();

    protected abstract void init();

    protected void closeReaders() throws IOException {
        if (this.readersToClose != null) {
            for (Reader r : this.readersToClose) {
                r.close();
            }
        }
    }

    protected void addToCloseReaderList(Reader r) {
        if (this.readersToClose == null) {
            this.readersToClose = new ArrayList<Reader>();
        }
        this.readersToClose.add(r);
    }

    protected void addToMetaData(List<ColumnMetaData> columns) {
        if (this.pzMetaData == null) {
            this.pzMetaData = new MetaData(columns, ParserUtils.buidColumnIndexMap(columns, this));
        } else {
            this.pzMetaData.setColumnsNames(columns);
            this.pzMetaData.setColumnIndexMap(ParserUtils.buidColumnIndexMap(columns, this));
        }
    }

    protected boolean isInitialised() {
        return this.initialised;
    }

    protected void setInitialised(boolean initialised) {
        this.initialised = initialised;
    }

    protected String getDataDefinition() {
        return this.dataDefinition;
    }

    protected void setDataDefinition(String dataDefinition) {
        this.dataDefinition = dataDefinition;
    }

    protected void addError(DefaultDataSet ds, String errorDesc, int lineNo, int errorLevel, String lineData) {
        if (errorLevel == 1 && this.isIgnoreParseWarnings()) {
            return;
        }
        ds.addError(new DataError(errorDesc, lineNo, errorLevel, lineData));
    }

    protected void addError(DefaultDataSet ds, String errorDesc, int lineNo, int errorLevel, String lineData, String lastColName, String lastColValue) {
        if (errorLevel == 1 && this.isIgnoreParseWarnings()) {
            return;
        }
        ds.addError(new DataError(errorDesc, lineNo, errorLevel, lineData, lastColName, lastColValue));
    }

    protected Reader getDataSourceReader() {
        return this.dataSourceReader;
    }

    protected void setDataSourceReader(Reader dataSourceReader) {
        this.dataSourceReader = dataSourceReader;
    }

    @Override
    public boolean isColumnNamesCaseSensitive() {
        return this.columnNamesCaseSensitive;
    }

    @Override
    public Parser setColumnNamesCaseSensitive(boolean columnNamesCaseSensitive) {
        this.columnNamesCaseSensitive = columnNamesCaseSensitive;
        return this;
    }

    @Override
    public boolean isIgnoreParseWarnings() {
        return this.ignoreParseWarnings;
    }

    @Override
    public Parser setIgnoreParseWarnings(boolean ignoreParseWarnings) {
        this.ignoreParseWarnings = ignoreParseWarnings;
        return this;
    }

    @Override
    public boolean isNullEmptyStrings() {
        return this.nullEmptyStrings;
    }

    @Override
    public Parser setNullEmptyStrings(boolean nullEmptyStrings) {
        this.nullEmptyStrings = nullEmptyStrings;
        return this;
    }

    public MetaData getPzMetaData() {
        return this.pzMetaData;
    }

    public void setPzMetaData(MetaData pzMap) {
        this.pzMetaData = pzMap;
    }

    @Override
    public boolean isFlagEmptyRows() {
        return this.flagEmptyRows;
    }

    @Override
    public Parser setFlagEmptyRows(boolean flagEmptyRows) {
        this.flagEmptyRows = flagEmptyRows;
        return this;
    }

    @Override
    public boolean isStoreRawDataToDataError() {
        return this.storeRawDataToDataError;
    }

    @Override
    public Parser setStoreRawDataToDataError(boolean storeRawDataToDataError) {
        this.storeRawDataToDataError = storeRawDataToDataError;
        return this;
    }

    @Override
    public boolean isStoreRawDataToDataSet() {
        return this.storeRawDataToDataSet;
    }

    @Override
    public Parser setStoreRawDataToDataSet(boolean storeRawDataToDataSet) {
        this.storeRawDataToDataSet = storeRawDataToDataSet;
        return this;
    }

    @Override
    public String getDataFileTable() {
        return this.dataFileTable;
    }

    @Override
    public Parser setDataFileTable(String dataFileTable) {
        this.dataFileTable = dataFileTable;
        return this;
    }

    @Override
    public String getDataStructureTable() {
        return this.dataStructureTable;
    }

    @Override
    public Parser setDataStructureTable(String dataStructureTable) {
        this.dataStructureTable = dataStructureTable;
        return this;
    }
}

