/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.AbstractFixedLengthParser;
import net.sf.flatpack.InitialisationException;
import net.sf.flatpack.xml.MapParser;

public class FixedLengthParser
extends AbstractFixedLengthParser {
    private InputStream pzmapXMLStream;
    private File pzmapXML;
    private Reader pzmapReader;
    private InputStream dataSourceStream = null;
    private File dataSource = null;

    public FixedLengthParser(InputStream pzmapXMLStream, InputStream dataSourceStream) {
        super(null);
        this.pzmapXMLStream = pzmapXMLStream;
        this.dataSourceStream = dataSourceStream;
    }

    public FixedLengthParser(File pzmapXML, File dataSource) {
        super(null);
        this.pzmapXML = pzmapXML;
        this.dataSource = dataSource;
    }

    public FixedLengthParser(Reader pzmapReader, Reader dataSourceReader) {
        super(dataSourceReader);
        this.pzmapReader = pzmapReader;
    }

    protected FixedLengthParser(Reader dataSourceReader, String dataDefinition) {
        super(dataSourceReader, dataDefinition);
    }

    @Override
    protected void init() {
        try {
            this.initStreamOrSource(this.dataSourceStream, this.dataSource);
            boolean closeMapReader = false;
            if (this.pzmapXML != null) {
                this.pzmapReader = new FileReader(this.pzmapXML);
                closeMapReader = true;
            } else if (this.pzmapXMLStream != null) {
                this.pzmapReader = new InputStreamReader(this.pzmapXMLStream);
                closeMapReader = true;
            }
            try {
                this.setPzMetaData(MapParser.parseMap(this.pzmapReader, this));
            }
            finally {
                if (closeMapReader) {
                    this.pzmapReader.close();
                }
            }
        }
        catch (Exception e) {
            throw new InitialisationException(e);
        }
    }
}

