/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.util;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.sf.flatpack.Parser;
import net.sf.flatpack.converter.Converter;
import net.sf.flatpack.converter.FPConvertException;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.util.FPException;
import net.sf.flatpack.xml.MetaData;
import net.sf.flatpack.xml.XMLRecordElement;

public final class ParserUtils {
    private static final String DATASTRUCTURE_LENGTH = "DATASTRUCTURE_LENGTH";

    private ParserUtils() {
    }

    public static List<String> splitLine(String line, char delimiter, char qualifier, int initialSize, boolean preserveLeadingWhitespace, boolean preserveTrailingWhitespace) {
        String trimmedLine;
        ArrayList<String> list = new ArrayList<String>(initialSize);
        if (delimiter == '\u0000') {
            list.add(line);
            return list;
        }
        if (line == null) {
            return list;
        }
        if (delimiter == '\t' || delimiter == ' ') {
            trimmedLine = line;
        } else {
            trimmedLine = line;
            if (!preserveLeadingWhitespace) {
                trimmedLine = ParserUtils.lTrim(line);
            }
            if (!preserveTrailingWhitespace) {
                trimmedLine = ParserUtils.rTrim(line);
            }
        }
        int size = trimmedLine.length();
        if (size == 0) {
            list.add("");
            return list;
        }
        boolean insideQualifier = false;
        char previousChar = '\u0000';
        boolean blockWasInQualifier = false;
        String doubleQualifier = "" + qualifier + qualifier;
        char[] newBlock = new char[size];
        int sizeSelected = 0;
        for (int i = 0; i < size; ++i) {
            char currentChar = trimmedLine.charAt(i);
            if (currentChar == '\ufeff') continue;
            if ((currentChar != delimiter || insideQualifier) && currentChar != qualifier) {
                previousChar = currentChar;
                newBlock[sizeSelected++] = currentChar;
                continue;
            }
            if (currentChar == delimiter) {
                if (!insideQualifier) {
                    String trimmed = String.valueOf(newBlock, 0, sizeSelected);
                    if (!blockWasInQualifier) {
                        if (!preserveLeadingWhitespace) {
                            trimmed = ParserUtils.lTrim(trimmed);
                        }
                        if (!preserveTrailingWhitespace) {
                            trimmed = ParserUtils.rTrim(trimmed);
                        }
                    }
                    if (trimmed == null || trimmed.length() == 1 && (trimmed.charAt(0) == delimiter || trimmed.charAt(0) == qualifier)) {
                        list.add("");
                    } else {
                        list.add(ParserUtils.replace(trimmed, doubleQualifier, String.valueOf(qualifier), -1));
                    }
                    blockWasInQualifier = false;
                    sizeSelected = 0;
                }
            } else if (currentChar == qualifier) {
                if (!insideQualifier && previousChar != qualifier) {
                    if (previousChar == delimiter || previousChar == '\u0000' || previousChar == ' ') {
                        insideQualifier = true;
                        sizeSelected = 0;
                    } else {
                        newBlock[sizeSelected++] = currentChar;
                    }
                } else {
                    if (insideQualifier && currentChar == qualifier && i + 1 < size && trimmedLine.charAt(i + 1) == qualifier) {
                        newBlock[sizeSelected++] = qualifier;
                        newBlock[sizeSelected++] = qualifier;
                        ++i;
                        previousChar = qualifier;
                        continue;
                    }
                    if (i + 1 < size && delimiter != ' ') {
                        int start = i + 1;
                        char charToCheck = trimmedLine.charAt(start);
                        while (charToCheck == ' ' && ++start != size) {
                            charToCheck = trimmedLine.charAt(start);
                        }
                        if (charToCheck != delimiter) {
                            previousChar = currentChar;
                            newBlock[sizeSelected++] = currentChar;
                            continue;
                        }
                    }
                    insideQualifier = false;
                    blockWasInQualifier = true;
                    if (i == size - 1) {
                        String str = String.valueOf(newBlock, 0, sizeSelected);
                        str = ParserUtils.replace(str, doubleQualifier, String.valueOf(qualifier), -1);
                        list.add(str);
                        sizeSelected = 0;
                    }
                }
            }
            previousChar = currentChar;
        }
        if (sizeSelected > 0) {
            String str = String.valueOf(newBlock, 0, sizeSelected);
            str = ParserUtils.replace(str, doubleQualifier, String.valueOf(qualifier), -1);
            if (blockWasInQualifier) {
                if (str.charAt(str.length() - 1) == qualifier) {
                    list.add(str.substring(0, str.length() - 1));
                } else {
                    list.add(str);
                }
            } else {
                String s = str;
                if (!preserveLeadingWhitespace) {
                    s = ParserUtils.lTrim(s);
                }
                if (!preserveTrailingWhitespace) {
                    s = ParserUtils.rTrim(s);
                }
                list.add(s);
            }
        } else if (trimmedLine.charAt(size - 1) == delimiter) {
            list.add("");
        }
        return list;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (text.length() == 0 || ParserUtils.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        increase = increase < 0 ? 0 : increase;
        int multiplier = max;
        if (max < 0) {
            multiplier = 16;
        } else if (max > 64) {
            multiplier = 64;
        }
        StringBuilder buf = new StringBuilder(text.length() + (increase *= multiplier));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static int getDelimiterOffset(String line, int start, char delimiter) {
        int idx = line.indexOf(delimiter, start);
        if (idx >= 0) {
            idx -= start - 1;
        }
        return idx;
    }

    public static String lTrim(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        int maxLength = value.length();
        for (offset = 0; offset < maxLength && (value.charAt(offset) == ' ' || value.charAt(offset) == '\t'); ++offset) {
        }
        if (offset > 0) {
            trimmed = value.substring(offset);
        }
        return trimmed;
    }

    public static String lTrimKeepTabs(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        int maxLength = value.length();
        for (offset = 0; offset < maxLength && value.charAt(offset) == ' '; ++offset) {
        }
        if (offset > 0) {
            trimmed = value.substring(offset);
        }
        return trimmed;
    }

    public static String rTrim(String value) {
        int offset;
        if (value == null) {
            return null;
        }
        String trimmed = value;
        for (offset = value.length() - 1; offset > -1 && (value.charAt(offset) == ' ' || value.charAt(offset) == '\t'); --offset) {
        }
        if (offset < value.length() - 1) {
            trimmed = value.substring(0, offset + 1);
        }
        return trimmed;
    }

    public static MetaData getPZMetaDataFromFile(String line, char delimiter, char qualifier, Parser p, boolean addSuffixToDuplicateColumnNames) {
        ArrayList<ColumnMetaData> results = new ArrayList<ColumnMetaData>();
        HashSet<String> dupCheck = new HashSet<String>();
        List<String> lineData = ParserUtils.splitLine(line, delimiter, qualifier, 10, false, false);
        for (String colName : lineData) {
            ColumnMetaData cmd = new ColumnMetaData();
            String colNameToUse = colName;
            if (dupCheck.contains(colNameToUse)) {
                if (!addSuffixToDuplicateColumnNames) {
                    throw new FPException("Duplicate Column Name In File: " + colNameToUse);
                }
                int count = 2;
                while (dupCheck.contains(colNameToUse + count)) {
                    ++count;
                }
                colNameToUse = colName + count;
            }
            cmd.setColName(colNameToUse);
            results.add(cmd);
            dupCheck.add(cmd.getColName());
        }
        return new MetaData(results, ParserUtils.buidColumnIndexMap(results, p));
    }

    public static boolean isMultiLine(char[] chrArry, char delimiter, char qualifier) {
        if (chrArry[chrArry.length - 1] != qualifier) {
            boolean qualiFound = false;
            block0: for (int i = chrArry.length - 1; i >= 0; --i) {
                if (chrArry[i] == ' ') continue;
                if (qualiFound) {
                    if (chrArry[i] == delimiter) {
                        boolean qualifiedContent = chrArry[0] == qualifier;
                        for (int index = 0; index < chrArry.length; ++index) {
                            char currentChar = chrArry[index];
                            boolean bl = qualifiedContent = currentChar == qualifier;
                            if (!qualifiedContent) continue;
                            while (chrArry.length > 0 && index < chrArry.length - 1) {
                                if (chrArry[index] == delimiter && chrArry[++index] == qualifier) {
                                    qualifiedContent = false;
                                }
                                ++index;
                            }
                        }
                        return qualifiedContent;
                    }
                    qualiFound = chrArry[i] == qualifier;
                    continue;
                }
                if (chrArry[i] == delimiter) {
                    for (int j = i - 1; j >= 0; --j) {
                        if (chrArry[j] == ' ') continue;
                        if (chrArry[j] != qualifier) continue block0;
                        return false;
                    }
                    continue;
                }
                if (chrArry[i] != qualifier) continue;
                qualiFound = true;
            }
        } else {
            for (int i = chrArry.length - 1; i >= 0; --i) {
                if (i == chrArry.length - 1 || chrArry[i] == ' ') continue;
                if (chrArry[i] == delimiter) {
                    boolean qualifiedContent = chrArry[0] == qualifier;
                    for (int index = 0; index < chrArry.length; ++index) {
                        char currentChar = chrArry[index];
                        boolean bl = qualifiedContent = currentChar == qualifier;
                        if (!qualifiedContent) continue;
                        while (index < chrArry.length) {
                            if (chrArry[index] == delimiter && chrArry[++index] == qualifier) {
                                qualifiedContent = false;
                            }
                            ++index;
                        }
                    }
                    return qualifiedContent;
                }
                break;
            }
        }
        return false;
    }

    public static Map<String, Integer> calculateRecordLengths(MetaData columnMD) {
        HashMap<String, Integer> recordLengths = new HashMap<String, Integer>();
        int recordLength = 0;
        for (ColumnMetaData cmd : columnMD.getColumnsNames()) {
            recordLength += cmd.getColLength();
        }
        recordLengths.put("detail", recordLength);
        Iterator<Map.Entry<String, XMLRecordElement>> columnMDIt = columnMD.xmlRecordIterator();
        while (columnMDIt.hasNext()) {
            Map.Entry<String, XMLRecordElement> entry = columnMDIt.next();
            List<ColumnMetaData> cmds = entry.getValue().getColumns();
            recordLength = 0;
            for (ColumnMetaData cmd : cmds) {
                recordLength += cmd.getColLength();
            }
            recordLengths.put(entry.getKey(), recordLength);
        }
        return recordLengths;
    }

    public static String getCMDKeyForDelimitedFile(MetaData columnMD, List<String> lineElements) {
        if (!columnMD.isAnyRecordFormatSpecified()) {
            return "detail";
        }
        Iterator<Map.Entry<String, XMLRecordElement>> mapEntries = columnMD.xmlRecordIterator();
        while (mapEntries.hasNext()) {
            String lineElement;
            Map.Entry<String, XMLRecordElement> entry = mapEntries.next();
            XMLRecordElement recordXMLElement = entry.getValue();
            if (recordXMLElement.getElementCount() > 0 && recordXMLElement.getElementCount() == lineElements.size()) {
                return entry.getKey();
            }
            if (recordXMLElement.getElementNumber() > lineElements.size() || !(lineElement = lineElements.get(recordXMLElement.getElementNumber() - 1)).equals(recordXMLElement.getIndicator())) continue;
            return entry.getKey();
        }
        return "detail";
    }

    public static List<ColumnMetaData> getColumnMetaData(String key, MetaData columnMD) {
        if (key == null || key.equals("detail") || key.equals("colIndex")) {
            return columnMD.getColumnsNames();
        }
        return columnMD.getListColumnsForRecord(key);
    }

    public static int getColumnIndex(String key, MetaData columnMD, String colName, boolean columNameCaseSensitive) {
        int idx;
        String column = colName;
        if (!columNameCaseSensitive) {
            column = colName.toLowerCase(Locale.getDefault());
        }
        if ((idx = columnMD.getColumnIndex(key, column)) < 0) {
            throw new NoSuchElementException("Column [" + column + "] does not exist, check case/spelling." + (key != null ? " key:[" + key + "]" : ""));
        }
        return idx;
    }

    public static String padding(int repeat, char padChar) {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static Map<String, Integer> buidColumnIndexMap(List<ColumnMetaData> columns, Parser p) {
        HashMap<String, Integer> map = null;
        if (columns != null && !columns.isEmpty()) {
            map = new HashMap<String, Integer>();
            int idx = 0;
            for (ColumnMetaData meta : columns) {
                String colName = meta.getColName();
                if (p != null && !p.isColumnNamesCaseSensitive()) {
                    colName = colName.toLowerCase(Locale.getDefault());
                }
                map.put(colName, idx++);
            }
        }
        return map;
    }

    public static String stripNonLongChars(String value) {
        char c;
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < value.length() && (c = value.charAt(i)) != '.'; ++i) {
            if ((c < '0' || c > '9') && c != '-') continue;
            newString.append(c);
        }
        int sLen = newString.length();
        String s = newString.toString();
        if (sLen == 0 || sLen == 1 && "-".equals(s)) {
            return "0";
        }
        return newString.toString();
    }

    public static String stripNonDoubleChars(String value) {
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if ((c < '0' || c > '9') && c != '-' && c != '.') continue;
            newString.append(c);
        }
        int sLen = newString.length();
        String s = newString.toString();
        if (sLen == 0 || sLen == 1 && (".".equals(s) || "-".equals(s))) {
            return "0";
        }
        return newString.toString();
    }

    public static Properties loadConvertProperties() throws IOException {
        Properties pzConvertProps = new Properties();
        URL url = ParserUtils.class.getClassLoader().getResource("fpconvert.properties");
        pzConvertProps.load(url.openStream());
        return pzConvertProps;
    }

    public static boolean isListElementsEmpty(List<String> l) {
        for (String s : l) {
            if (s == null || s.trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Object runPzConverter(Properties classXref, String value, Class<?> typeToReturn) {
        String sConverter = classXref.getProperty(typeToReturn.getName());
        if (sConverter == null) {
            throw new FPConvertException(typeToReturn.getName() + " is not registered in pzconvert.properties");
        }
        try {
            Converter pzconverter = (Converter)Class.forName(sConverter).newInstance();
            return pzconverter.convertValue(value);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new FPConvertException(ex);
        }
    }

    public static List<ColumnMetaData> buildMDFromSQLTable(Connection con, String dataDefinition, Parser parser) throws SQLException {
        ArrayList<ColumnMetaData> cmds = new ArrayList<ColumnMetaData>();
        String dfTbl = parser != null ? parser.getDataFileTable() : "DATAFILE";
        String dsTbl = parser != null ? parser.getDataStructureTable() : "DATASTRUCTURE";
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("SELECT * FROM ").append(dfTbl).append(" INNER JOIN ").append(dsTbl).append(" ON ").append(dfTbl).append(".DATAFILE_NO = ").append(dsTbl).append(".DATAFILE_NO WHERE DATAFILE_DESC = ? ORDER BY DATASTRUCTURE_COL_ORDER");
        try (PreparedStatement stmt = con.prepareStatement(sqlSb.toString());){
            stmt.setString(1, dataDefinition);
            try (ResultSet rs = stmt.executeQuery();){
                int recPosition = 1;
                while (rs.next()) {
                    ColumnMetaData column = new ColumnMetaData();
                    column.setColName(rs.getString("DATASTRUCTURE_COLUMN"));
                    column.setColLength(rs.getInt(DATASTRUCTURE_LENGTH));
                    column.setStartPosition(recPosition);
                    column.setEndPosition(recPosition + rs.getInt(DATASTRUCTURE_LENGTH) - 1);
                    recPosition += rs.getInt(DATASTRUCTURE_LENGTH);
                    cmds.add(column);
                }
            }
            if (cmds.isEmpty()) {
                throw new FPException("Data File Key [" + dataDefinition + "] Is Not In The database OR No Columns Specified In Table");
            }
        }
        return cmds;
    }
}

