/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.sf.flatpack.DataError;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.Record;
import net.sf.flatpack.ordering.OrderBy;
import org.apache.camel.component.flatpack.FlatpackConverter;

public class DataSetList
extends AbstractList<Map<String, Object>>
implements DataSet {
    private final DataSet dataSet;

    public DataSetList(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    @Override
    public Map<String, Object> get(int index) {
        this.dataSet.absolute(index);
        return FlatpackConverter.toMap(this.dataSet);
    }

    @Override
    public int size() {
        return this.dataSet.getRowCount();
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.dataSet.goTop();
        return new Iterator<Map<String, Object>>(){
            private boolean hasNext;
            {
                this.hasNext = DataSetList.this.dataSet.next();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Map<String, Object> next() {
                Map<String, Object> result = FlatpackConverter.toMap(DataSetList.this.dataSet);
                this.hasNext = DataSetList.this.dataSet.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported");
            }
        };
    }

    @Override
    public void goTop() {
        this.dataSet.goTop();
    }

    @Override
    public void goBottom() {
        this.dataSet.goBottom();
    }

    @Override
    public boolean previous() {
        return this.dataSet.previous();
    }

    @Override
    public List<DataError> getErrors() {
        return this.dataSet.getErrors();
    }

    @Override
    public void remove() {
        this.dataSet.remove();
    }

    @Override
    public int getIndex() {
        return this.dataSet.getIndex();
    }

    @Override
    public int getRowCount() {
        return this.dataSet.getRowCount();
    }

    @Override
    public int getErrorCount() {
        return this.dataSet.getErrorCount();
    }

    @Override
    public boolean isAnError(int lineNo) {
        return this.dataSet.isAnError(lineNo);
    }

    @Override
    public void orderRows(OrderBy ob) {
        this.dataSet.orderRows(ob);
    }

    @Override
    public void setLowerCase() {
        this.dataSet.setLowerCase();
    }

    @Override
    public void setUpperCase() {
        this.dataSet.setUpperCase();
    }

    @Override
    public void absolute(int localPointer) {
        this.dataSet.absolute(localPointer);
    }

    @Override
    public void setStrictNumericParse(boolean strictNumericParse) {
        this.dataSet.setStrictNumericParse(strictNumericParse);
    }

    @Override
    public void setPZConvertProps(Properties props) {
        this.dataSet.setPZConvertProps(props);
    }

    @Override
    public void setValue(String column, String value) {
        this.dataSet.setValue(column, value);
    }

    @Override
    public void clearRows() {
        this.dataSet.clearRows();
    }

    @Override
    public void clearErrors() {
        this.dataSet.clearErrors();
    }

    @Override
    public void clearAll() {
        this.dataSet.clearAll();
    }

    @Override
    public String getString(String column) {
        return this.dataSet.getString(column);
    }

    @Override
    public double getDouble(String column) {
        return this.dataSet.getDouble(column);
    }

    @Override
    public BigDecimal getBigDecimal(String column) {
        return this.dataSet.getBigDecimal(column);
    }

    @Override
    public int getInt(String column) {
        return this.dataSet.getInt(column);
    }

    @Override
    public long getLong(String column) {
        return this.dataSet.getLong(column);
    }

    @Override
    public Date getDate(String column) throws ParseException {
        return this.dataSet.getDate(column);
    }

    @Override
    public Date getDate(String column, SimpleDateFormat sdf) throws ParseException {
        return this.dataSet.getDate(column, sdf);
    }

    @Override
    public Object getObject(String column, Class<?> classToConvertTo) {
        return this.dataSet.getObject(column, classToConvertTo);
    }

    @Override
    public String[] getColumns() {
        return this.dataSet.getColumns();
    }

    @Override
    public String[] getColumns(String recordID) {
        return this.dataSet.getColumns(recordID);
    }

    @Override
    public int getRowNo() {
        return this.dataSet.getRowNo();
    }

    @Override
    public boolean isRecordID(String recordID) {
        return this.dataSet.isRecordID(recordID);
    }

    @Override
    public boolean contains(String column) {
        return this.dataSet.contains(column);
    }

    @Override
    public boolean isRowEmpty() {
        return this.dataSet.isRowEmpty();
    }

    @Override
    public String getRawData() {
        return this.dataSet.getRawData();
    }

    @Override
    public boolean next() {
        return this.dataSet.next();
    }

    @Override
    public String getString(String column, Supplier<String> defaultSupplier) {
        return this.dataSet.getString(column, defaultSupplier);
    }

    @Override
    public double getDouble(String column, DoubleSupplier defaultSupplier) {
        return this.dataSet.getDouble(column, defaultSupplier);
    }

    @Override
    public BigDecimal getBigDecimal(String column, Supplier<BigDecimal> defaultSupplier) {
        return this.dataSet.getBigDecimal(column, defaultSupplier);
    }

    @Override
    public int getInt(String column, IntSupplier defaultSupplier) {
        return this.dataSet.getInt(column, defaultSupplier);
    }

    @Override
    public long getLong(String column, LongSupplier defaultSupplier) {
        return this.dataSet.getLong(column, defaultSupplier);
    }

    @Override
    public Date getDate(String column, Supplier<Date> defaultSupplier) throws ParseException {
        return this.dataSet.getDate(column, defaultSupplier);
    }

    @Override
    public Date getDate(String column, SimpleDateFormat sdf, Supplier<Date> defaultSupplier) throws ParseException {
        return this.dataSet.getDate(column, sdf, defaultSupplier);
    }

    @Override
    public LocalDate getLocalDate(String column, Supplier<LocalDate> defaultSupplier) throws ParseException {
        return this.dataSet.getLocalDate(column, defaultSupplier);
    }

    @Override
    public LocalDate getLocalDate(String column) throws ParseException {
        return this.dataSet.getLocalDate(column);
    }

    @Override
    public LocalDate getLocalDate(String column, DateTimeFormatter formatter) throws ParseException {
        return this.dataSet.getLocalDate(column, formatter);
    }

    @Override
    public LocalDate getLocalDate(String column, String dateFormat, Supplier<LocalDate> defaultSupplier) throws ParseException {
        return this.dataSet.getLocalDate(column, dateFormat, defaultSupplier);
    }

    @Override
    public LocalDate getLocalDate(String column, String dateFormat) throws ParseException {
        return this.dataSet.getLocalDate(column, dateFormat);
    }

    @Override
    public String getRecordID() {
        return this.dataSet.getRecordID();
    }

    @Override
    public Optional<Record> getRecord() {
        return this.dataSet.getRecord();
    }
}

