/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.flatpack.FlatpackEndpoint;
import org.apache.camel.component.flatpack.FlatpackType;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="flatpack")
public class FlatpackComponent
extends DefaultComponent {
    public static final String HEADER_ID = "header";
    public static final String TRAILER_ID = "trailer";

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean fixed = false;
        if (remaining.startsWith("fixed:")) {
            fixed = true;
            remaining = remaining.substring("fixed:".length());
        } else {
            remaining = remaining.startsWith("delim:") ? remaining.substring("delim:".length()) : "";
        }
        String resourceUri = remaining;
        FlatpackType type = fixed ? FlatpackType.fixed : FlatpackType.delim;
        FlatpackEndpoint answer = new FlatpackEndpoint(uri, this, resourceUri);
        answer.setType(type);
        this.setProperties(answer, parameters);
        return answer;
    }
}

