/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.DataSet;
import net.sf.flatpack.DefaultParserFactory;
import net.sf.flatpack.Parser;
import net.sf.flatpack.ParserFactory;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.flatpack.FlatpackConstants;
import org.apache.camel.component.flatpack.FlatpackConsumer;
import org.apache.camel.component.flatpack.FlatpackProducer;
import org.apache.camel.component.flatpack.FlatpackType;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultPollingEndpoint;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="1.4.0", scheme="flatpack", title="Flatpack", syntax="flatpack:type:resourceUri", category={Category.TRANSFORMATION}, headersClass=FlatpackConstants.class)
public class FlatpackEndpoint
extends DefaultPollingEndpoint {
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private ParserFactory parserFactory = DefaultParserFactory.getInstance();
    @UriPath
    @Metadata(required=false, defaultValue="delim")
    private FlatpackType type;
    @UriPath
    @Metadata(required=true)
    private String resourceUri;
    @UriParam(defaultValue="true")
    private boolean splitRows = true;
    @UriParam
    private boolean allowShortLines;
    @UriParam
    private boolean ignoreExtraColumns;
    @UriParam(defaultValue=",")
    private char delimiter = (char)44;
    @UriParam
    private char textQualifier = (char)34;
    @UriParam(defaultValue="true")
    private boolean ignoreFirstRecord = true;

    public FlatpackEndpoint() {
    }

    public FlatpackEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component);
        this.resourceUri = resourceUri;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new FlatpackProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        FlatpackConsumer consumer = new FlatpackConsumer(this, processor, this.loadBalancer);
        this.configureConsumer(consumer);
        return consumer;
    }

    public void processDataSet(Exchange originalExchange, DataSet dataSet, int counter) throws Exception {
        Exchange exchange = ExchangeHelper.createCorrelatedCopy(originalExchange, false);
        Message in = exchange.getIn();
        in.setBody(dataSet);
        in.setHeader("CamelFlatpackCounter", counter);
        this.loadBalancer.process(exchange);
    }

    public Parser createParser(Exchange exchange) throws Exception {
        Reader bodyReader = null;
        try {
            if (FlatpackType.fixed == this.type) {
                bodyReader = exchange.getIn().getMandatoryBody(Reader.class);
                return this.createFixedParser(this.resourceUri, bodyReader);
            }
            return this.createDelimitedParser(exchange);
        }
        catch (Exception e) {
            IOHelper.close(bodyReader);
            throw e;
        }
    }

    protected Parser createFixedParser(String resourceUri, Reader bodyReader) throws IOException {
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), resourceUri);
        InputStreamReader reader = new InputStreamReader(is);
        Parser parser = this.getParserFactory().newFixedLengthParser(reader, bodyReader);
        if (this.isAllowShortLines()) {
            parser.setHandlingShortLines(true);
            parser.setIgnoreParseWarnings(true);
        }
        if (this.isIgnoreExtraColumns()) {
            parser.setIgnoreExtraColumns(true);
            parser.setIgnoreParseWarnings(true);
        }
        return parser;
    }

    public Parser createDelimitedParser(Exchange exchange) throws InvalidPayloadException, IOException {
        Parser parser;
        Reader bodyReader = exchange.getIn().getMandatoryBody(Reader.class);
        if (ObjectHelper.isEmpty(this.getResourceUri())) {
            parser = this.getParserFactory().newDelimitedParser(bodyReader, this.delimiter, this.textQualifier);
        } else {
            InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), this.resourceUri);
            InputStreamReader reader = new InputStreamReader(is, ExchangeHelper.getCharsetName(exchange));
            parser = this.getParserFactory().newDelimitedParser(reader, bodyReader, this.delimiter, this.textQualifier, this.ignoreFirstRecord);
        }
        if (this.isAllowShortLines()) {
            parser.setHandlingShortLines(true);
            parser.setIgnoreParseWarnings(true);
        }
        if (this.isIgnoreExtraColumns()) {
            parser.setIgnoreExtraColumns(true);
            parser.setIgnoreParseWarnings(true);
        }
        return parser;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    public void setParserFactory(ParserFactory parserFactory) {
        this.parserFactory = parserFactory;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public boolean isSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(boolean splitRows) {
        this.splitRows = splitRows;
    }

    public boolean isAllowShortLines() {
        return this.allowShortLines;
    }

    public void setAllowShortLines(boolean allowShortLines) {
        this.allowShortLines = allowShortLines;
    }

    public void setIgnoreExtraColumns(boolean ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
    }

    public boolean isIgnoreExtraColumns() {
        return this.ignoreExtraColumns;
    }

    public FlatpackType getType() {
        return this.type;
    }

    public void setType(FlatpackType type) {
        this.type = type;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }
}

