/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import net.sf.flatpack.DataSet;
import net.sf.flatpack.Parser;
import org.apache.camel.Exchange;
import org.apache.camel.component.flatpack.FlatpackEndpoint;
import org.apache.camel.component.flatpack.FlatpackException;
import org.apache.camel.support.DefaultProducer;

class FlatpackProducer
extends DefaultProducer {
    private FlatpackEndpoint endpoint;

    FlatpackProducer(FlatpackEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Parser parser = this.endpoint.createParser(exchange);
        DataSet dataSet = parser.parse();
        if (dataSet.getErrorCount() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Flatpack has found %s errors while parsing", dataSet.getErrorCount()));
            throw new FlatpackException(sb.toString(), exchange, dataSet.getErrors());
        }
        if (this.endpoint.isSplitRows()) {
            int counter = 0;
            while (dataSet.next()) {
                this.endpoint.processDataSet(exchange, dataSet, counter++);
            }
        } else {
            this.endpoint.processDataSet(exchange, dataSet, dataSet.getRowCount());
        }
    }
}

