/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.StartupStep;
import org.apache.camel.ValueHolder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultModel;
import org.apache.camel.impl.PreconditionHelper;
import org.apache.camel.impl.engine.DefaultExecutorServiceManager;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.impl.engine.SimpleCamelContext;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.InvertingPackageScanFilter;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.LocalBeanRepositoryAware;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.LocalBeanRegistry;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.concurrent.NamedThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCamelContext
extends SimpleCamelContext
implements ModelCamelContext {
    private static final ThreadLocal<Map<String, Object>> OPTIONS = new NamedThreadLocal<Map>("CamelContextOptions", HashMap::new);
    private static final String OPTION_NO_START = "OptionNoStart";
    private static final String OPTION_DISABLE_JMX = "OptionDisableJMX";
    private static final String OPTION_EXCLUDE_ROUTES = "OptionExcludeRoutes";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCamelContext.class);
    private static final UuidGenerator UUID = new SimpleUuidGenerator();
    private Model model = new DefaultModel(this);

    public DefaultCamelContext() {
        this(true);
    }

    public DefaultCamelContext(BeanRepository repository) {
        this(new DefaultRegistry(repository));
    }

    public DefaultCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    public DefaultCamelContext(boolean init) {
        super(init);
        if (DefaultCamelContext.isDisableJmx()) {
            this.disableJMX();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        OPTIONS.remove();
    }

    @Override
    protected void doDumpRoutes() {
        String xml;
        OptionalIdentifiedDefinition def;
        ModelToXMLDumper dumper = this.getModelToXMLDumper();
        int size = this.getRouteDefinitions().size();
        if (size > 0) {
            LOG.info("Dumping {} routes as XML", (Object)size);
            def = new RoutesDefinition();
            ((RoutesDefinition)def).setRoutes(this.getRouteDefinitions());
            try {
                xml = dumper.dumpModelAsXml(this, def, true, true);
                xml = StringHelper.replaceFirst(xml, "xmlns=\"http://camel.apache.org/schema/spring\">", "xmlns=\"http://camel.apache.org/schema/spring\">\n");
                xml = xml.replace("</route>", "</route>\n");
                LOG.info("\n\n{}\n", (Object)xml);
            }
            catch (Exception e) {
                LOG.warn("Error dumping routes to XML due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
            }
        }
        if ((size = this.getRestDefinitions().size()) > 0) {
            LOG.info("Dumping {} rests as XML", (Object)size);
            def = new RestsDefinition();
            ((RestsDefinition)def).setRests(this.getRestDefinitions());
            try {
                xml = dumper.dumpModelAsXml(this, def, true, true);
                xml = StringHelper.replaceFirst(xml, "xmlns=\"http://camel.apache.org/schema/spring\">", "xmlns=\"http://camel.apache.org/schema/spring\">\n");
                xml = xml.replace("</rest>", "</rest>\n");
                LOG.info("\n\n{}\n", (Object)xml);
            }
            catch (Exception e) {
                LOG.warn("Error dumping rests to XML due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
            }
        }
        if ((size = this.getRouteTemplateDefinitions().size()) > 0) {
            LOG.info("Dumping {} route templates as XML", (Object)size);
            def = new RouteTemplatesDefinition();
            ((RouteTemplatesDefinition)def).setRouteTemplates(this.getRouteTemplateDefinitions());
            try {
                xml = dumper.dumpModelAsXml(this, def, true, true);
                xml = StringHelper.replaceFirst(xml, "xmlns=\"http://camel.apache.org/schema/spring\">", "xmlns=\"http://camel.apache.org/schema/spring\">\n");
                xml = xml.replace("</routeTemplate>", "</routeTemplate>\n");
                LOG.info("\n\n{}\n", (Object)xml);
            }
            catch (Exception e) {
                LOG.warn("Error dumping route-templates to XML due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void setNoStart(boolean b) {
        DefaultCamelContext.getOptions().put(OPTION_NO_START, b);
    }

    public static boolean isNoStart() {
        return (Boolean)DefaultCamelContext.getOptions().getOrDefault(OPTION_NO_START, Boolean.FALSE);
    }

    public static void setDisableJmx(boolean b) {
        DefaultCamelContext.getOptions().put(OPTION_DISABLE_JMX, b);
    }

    public static boolean isDisableJmx() {
        return (Boolean)DefaultCamelContext.getOptions().getOrDefault(OPTION_DISABLE_JMX, Boolean.getBoolean("org.apache.camel.jmx.disabled"));
    }

    @Override
    public String getTestExcludeRoutes() {
        return DefaultCamelContext.getExcludeRoutes();
    }

    public static String getExcludeRoutes() {
        return (String)DefaultCamelContext.getOptions().get(OPTION_EXCLUDE_ROUTES);
    }

    public static void setExcludeRoutes(String s) {
        DefaultCamelContext.getOptions().put(OPTION_EXCLUDE_ROUTES, s);
    }

    public static void clearOptions() {
        OPTIONS.get().clear();
    }

    private static Map<String, Object> getOptions() {
        return OPTIONS.get();
    }

    @Override
    public void start() {
        if (DefaultCamelContext.isNoStart()) {
            LOG.trace("Ignoring start() as NO_START is true");
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            StopWatch watch = new StopWatch();
            super.start();
            LOG.debug("start() took {} millis", (Object)watch.taken());
        } else {
            LOG.trace("Ignoring start() as Camel is already started");
        }
    }

    @Override
    protected PackageScanClassResolver createPackageScanClassResolver() {
        PackageScanClassResolver resolver = super.createPackageScanClassResolver();
        String excluded = DefaultCamelContext.getExcludeRoutes();
        if (ObjectHelper.isNotEmpty(excluded)) {
            HashSet excludedClasses = new HashSet();
            for (String str : excluded.split(",")) {
                excludedClasses.add(this.getClassResolver().resolveClass(str));
            }
            resolver.addFilter(new InvertingPackageScanFilter(new AssignableToPackageScanFilter(excludedClasses)));
        }
        return resolver;
    }

    @Override
    public void disposeModel() {
        LOG.debug("Disposing Model on CamelContext");
        this.model = null;
    }

    @Override
    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addModelLifecycleStrategy(modelLifecycleStrategy);
    }

    @Override
    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelLifecycleStrategies();
    }

    @Override
    public void addRouteConfiguration(RouteConfigurationDefinition routesConfiguration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteConfiguration(routesConfiguration);
    }

    @Override
    public void addRouteConfigurations(List<RouteConfigurationDefinition> routesConfigurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteConfigurations(routesConfigurations);
    }

    @Override
    public List<RouteConfigurationDefinition> getRouteConfigurationDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteConfigurationDefinitions();
    }

    @Override
    public RouteConfigurationDefinition getRouteConfigurationDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteConfigurationDefinition(id);
    }

    @Override
    public void removeRouteConfiguration(RouteConfigurationDefinition routeConfigurationDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.removeRouteConfiguration(routeConfigurationDefinition);
    }

    @Override
    public List<RouteDefinition> getRouteDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteDefinitions();
    }

    @Override
    public RouteDefinition getRouteDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteDefinition(id);
    }

    @Override
    public void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteDefinitions(routeDefinitions);
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteDefinition(routeDefinition);
    }

    @Override
    public void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        if (!this.isLockModel()) {
            this.model.removeRouteDefinitions(routeDefinitions);
        }
    }

    @Override
    public void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        if (!this.isLockModel()) {
            this.model.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteTemplateDefinitions();
    }

    @Override
    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteTemplateDefinition(id);
    }

    @Override
    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteTemplateDefinitions(routeTemplateDefinitions);
    }

    @Override
    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteTemplateDefinition(routeTemplateDefinition);
    }

    @Override
    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinitions(routeTemplateDefinitions);
        }
    }

    @Override
    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinition(routeTemplateDefinition);
        }
    }

    @Override
    public void removeRouteTemplateDefinitions(String pattern) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinitions(pattern);
        }
    }

    @Override
    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteTemplateDefinitionConverter(templateIdPattern, converter);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, parameters);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, prefixId, parameters);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, RouteTemplateContext routeTemplateContext) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, routeTemplateContext);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.addRouteFromTemplate(routeId, routeTemplateId, prefixId, routeTemplateContext);
    }

    @Override
    public void addRouteFromTemplatedRoute(TemplatedRouteDefinition templatedRouteDefinition) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRouteFromTemplatedRoute(templatedRouteDefinition);
    }

    @Override
    public void removeRouteTemplates(String pattern) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        if (!this.isLockModel()) {
            this.model.removeRouteTemplateDefinitions(pattern);
        }
    }

    @Override
    public List<RestDefinition> getRestDefinitions() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRestDefinitions();
    }

    @Override
    public void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addRestDefinitions(restDefinitions, addToRoutes);
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setDataFormats(dataFormats);
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getDataFormats();
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.resolveDataFormatDefinition(name);
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getProcessorDefinition(id);
    }

    @Override
    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getProcessorDefinition(id, type);
    }

    @Override
    public void setValidators(List<ValidatorDefinition> validators) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setValidators(validators);
    }

    @Override
    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getResilience4jConfiguration(id);
    }

    @Override
    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setResilience4jConfiguration(configuration);
    }

    @Override
    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setResilience4jConfigurations(configurations);
    }

    @Override
    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addResilience4jConfiguration(id, configuration);
    }

    @Override
    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getFaultToleranceConfiguration(id);
    }

    @Override
    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setFaultToleranceConfiguration(configuration);
    }

    @Override
    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setFaultToleranceConfigurations(configurations);
    }

    @Override
    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addFaultToleranceConfiguration(id, configuration);
    }

    @Override
    public List<ValidatorDefinition> getValidators() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getValidators();
    }

    @Override
    public void setTransformers(List<TransformerDefinition> transformers) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setTransformers(transformers);
    }

    @Override
    public List<TransformerDefinition> getTransformers() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getTransformers();
    }

    @Override
    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getServiceCallConfiguration(serviceName);
    }

    @Override
    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setServiceCallConfiguration(configuration);
    }

    @Override
    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setServiceCallConfigurations(configurations);
    }

    @Override
    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.addServiceCallConfiguration(serviceName, configuration);
    }

    @Override
    public void setRouteFilterPattern(String include, String exclude) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setRouteFilterPattern(include, exclude);
    }

    @Override
    public void setRouteFilter(Function<RouteDefinition, Boolean> filter) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setRouteFilter(filter);
    }

    @Override
    public Function<RouteDefinition, Boolean> getRouteFilter() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getRouteFilter();
    }

    @Override
    public ModelReifierFactory getModelReifierFactory() {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory();
    }

    @Override
    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.setModelReifierFactory(modelReifierFactory);
    }

    @Override
    protected void bindDataFormats() throws Exception {
        if (this.model != null) {
            for (Map.Entry<String, DataFormatDefinition> e : this.model.getDataFormats().entrySet()) {
                String id = e.getKey();
                DataFormatDefinition def = e.getValue();
                LOG.debug("Creating Dataformat with id: {} and definition: {}", (Object)id, (Object)def);
                DataFormat df = this.model.getModelReifierFactory().createDataFormat(this, def);
                this.addService(df, true);
                this.getRegistry().bind(id, df);
            }
        }
    }

    @Override
    protected synchronized void shutdownRouteService(RouteService routeService) throws Exception {
        RouteDefinition rd;
        if (this.model != null && (rd = this.model.getRouteDefinition(routeService.getId())) != null) {
            this.model.getRouteDefinitions().remove(rd);
        }
        super.shutdownRouteService(routeService);
    }

    @Override
    protected boolean isStreamCachingInUse() throws Exception {
        boolean streamCachingInUse = super.isStreamCachingInUse();
        if (!streamCachingInUse) {
            for (RouteDefinition route : this.model.getRouteDefinitions()) {
                Boolean routeCache = CamelContextHelper.parseBoolean(this, route.getStreamCache());
                if (routeCache == null || !routeCache.booleanValue()) continue;
                streamCachingInUse = true;
                break;
            }
        }
        return streamCachingInUse;
    }

    @Override
    public void startRouteDefinitions() throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        List<RouteDefinition> routeDefinitions = this.model.getRouteDefinitions();
        if (routeDefinitions != null) {
            ArrayList<RouteDefinition> toBeStarted = new ArrayList<RouteDefinition>(routeDefinitions);
            this.startRouteDefinitions(toBeStarted);
        }
    }

    @Override
    public void removeRouteDefinitionsFromTemplate() throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        ArrayList<RouteDefinition> toBeRemoved = new ArrayList<RouteDefinition>();
        for (RouteDefinition rd : this.model.getRouteDefinitions()) {
            if (rd.isTemplate() == null || !rd.isTemplate().booleanValue()) continue;
            toBeRemoved.add(rd);
        }
        this.removeRouteDefinitions(toBeRemoved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRouteDefinitions(List<RouteDefinition> routeDefinitions) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        boolean alreadyStartingRoutes = this.isStartingRoutes();
        if (!alreadyStartingRoutes) {
            this.setStartingRoutes(true);
        }
        PropertiesComponent pc = this.getCamelContextReference().getPropertiesComponent();
        LocalBeanRepositoryAware localBeans = null;
        if (this.getCamelContextReference().getRegistry() instanceof LocalBeanRepositoryAware) {
            localBeans = (LocalBeanRepositoryAware)((Object)this.getCamelContextReference().getRegistry());
        }
        try {
            RouteDefinitionHelper.forceAssignIds(this.getCamelContextReference(), routeDefinitions);
            ArrayList<RouteDefinition> routeDefinitionsToRemove = null;
            for (RouteDefinition routeDefinition : routeDefinitions) {
                String duplicate = RouteDefinitionHelper.validateUniqueIds(routeDefinition, routeDefinitions, routeDefinition.getNodePrefixId());
                if (duplicate != null) {
                    throw new FailedToStartRouteException(routeDefinition.getId(), "duplicate id detected: " + duplicate + ". Please correct ids to be unique among all your routes.");
                }
                if (routeDefinition.isTemplate() != null && routeDefinition.isTemplate().booleanValue() && routeDefinition.getTemplateParameters() != null) {
                    if (routeDefinition.getRouteTemplateContext().getConfigurer() != null) {
                        routeDefinition.getRouteTemplateContext().getConfigurer().accept(routeDefinition.getRouteTemplateContext());
                    }
                    HashMap<Object, Object> params = new HashMap<Object, Object>(routeDefinition.getTemplateParameters());
                    LocalBeanRegistry bbr = (LocalBeanRegistry)routeDefinition.getRouteTemplateContext().getLocalBeanRepository();
                    LocalBeanRegistry bbrCopy = new LocalBeanRegistry();
                    if (bbr != null && !bbr.isEmpty()) {
                        for (Map.Entry entry : params.entrySet()) {
                            Object value = entry.getValue();
                            if (!(value instanceof String)) continue;
                            String oldKey = (String)value;
                            boolean clash = bbr.keys().stream().anyMatch(k -> k.equals(oldKey));
                            if (!clash) continue;
                            String newKey = oldKey + "-" + UUID.generateUuid();
                            LOG.debug("Route: {} re-assigning local-bean id: {} to: {} to ensure ids are globally unique", new Object[]{routeDefinition.getId(), oldKey, newKey});
                            bbrCopy.put(newKey, (Map)bbr.remove(oldKey));
                            entry.setValue((CallSite)((Object)newKey));
                        }
                        for (String string : bbr.keySet()) {
                            String newKey = string + "-" + UUID.generateUuid();
                            LOG.debug("Route: {} re-assigning local-bean id: {} to: {} to ensure ids are globally unique", new Object[]{routeDefinition.getId(), string, newKey});
                            bbrCopy.put(newKey, (Map)bbr.get(string));
                            if (params.containsKey(string)) continue;
                            params.put(string, newKey);
                        }
                    }
                    OrderedLocationProperties prop = new OrderedLocationProperties();
                    if (routeDefinition.getTemplateDefaultParameters() != null) {
                        params.forEach((k, v) -> {
                            Object dv = routeDefinition.getTemplateDefaultParameters().get(k);
                            prop.put(routeDefinition.getLocation(), k, v, dv);
                        });
                    } else {
                        prop.putAll(routeDefinition.getLocation(), params);
                    }
                    pc.setLocalProperties(prop);
                    if (localBeans != null && bbrCopy != null) {
                        localBeans.setLocalBeanRepository(bbrCopy);
                    }
                    ProcessorDefinitionHelper.resetAllAutoAssignedNodeIds(routeDefinition);
                    RouteDefinitionHelper.initParent(routeDefinition);
                }
                if (this.includedRoute(routeDefinition)) {
                    if (!routeDefinition.isPrepared()) {
                        RouteDefinitionHelper.prepareRoute(this.getCamelContextReference(), routeDefinition);
                        routeDefinition.markPrepared();
                    }
                    StartupStepRecorder recorder = this.getCamelContextReference().adapt(ExtendedCamelContext.class).getStartupStepRecorder();
                    StartupStep step = recorder.beginStep(Route.class, routeDefinition.getRouteId(), "Create Route");
                    Route route = this.model.getModelReifierFactory().createRoute(this, routeDefinition);
                    recorder.endStep(step);
                    RouteService routeService = new RouteService(route);
                    this.startRouteService(routeService, true);
                } else {
                    if (routeDefinitionsToRemove == null) {
                        routeDefinitionsToRemove = new ArrayList<RouteDefinition>(routeDefinitions.size());
                    }
                    routeDefinitionsToRemove.add(routeDefinition);
                }
                pc.setLocalProperties(null);
                if (localBeans == null) continue;
                localBeans.setLocalBeanRepository(null);
            }
            if (routeDefinitionsToRemove != null) {
                this.model.removeRouteDefinitions(routeDefinitionsToRemove);
            }
        }
        finally {
            if (!alreadyStartingRoutes) {
                this.setStartingRoutes(false);
            }
            pc.setLocalProperties(null);
            if (localBeans != null) {
                localBeans.setLocalBeanRepository(null);
            }
        }
    }

    @Override
    protected ExecutorServiceManager createExecutorServiceManager() {
        return new DefaultExecutorServiceManager(this);
    }

    @Override
    public Processor createErrorHandler(Route route, Processor processor) throws Exception {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory().createErrorHandler(route, processor);
    }

    @Override
    public Expression createExpression(ExpressionDefinition definition) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory().createExpression(this, definition);
    }

    @Override
    public Predicate createPredicate(ExpressionDefinition definition) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        return this.model.getModelReifierFactory().createPredicate(this, definition);
    }

    @Override
    public RouteDefinition adviceWith(RouteDefinition definition, AdviceWithRouteBuilder builder) throws Exception {
        return AdviceWith.adviceWith(definition, (CamelContext)this, (RouteBuilder)builder);
    }

    @Override
    public void registerValidator(ValidatorDefinition def) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.getValidators().add(def);
        Validator validator = this.model.getModelReifierFactory().createValidator(this, def);
        this.getValidatorRegistry().put(DefaultCamelContext.createValidatorKey(def), validator);
    }

    private static ValueHolder<String> createValidatorKey(ValidatorDefinition def) {
        return new ValidatorKey(new DataType(def.getType()));
    }

    @Override
    public void registerTransformer(TransformerDefinition def) {
        if (this.model == null && this.isLightweight()) {
            throw new IllegalStateException("Access to model not supported in lightweight mode");
        }
        this.model.getTransformers().add(def);
        Transformer transformer = this.model.getModelReifierFactory().createTransformer(this, def);
        this.getTransformerRegistry().put(DefaultCamelContext.createTransformerKey(def), transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeRoute(String routeId, LoggingLevel loggingLevel) throws Exception {
        Model model = this.model;
        synchronized (model) {
            DefaultCamelContext defaultCamelContext = this;
            synchronized (defaultCamelContext) {
                RouteDefinition def;
                boolean removed = super.removeRoute(routeId, loggingLevel);
                if (removed && (def = this.getRouteDefinition(routeId)) != null) {
                    this.removeRouteDefinition(def);
                }
                return removed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeRoute(String routeId) throws Exception {
        Model model = this.model;
        synchronized (model) {
            return super.removeRoute(routeId);
        }
    }

    private boolean includedRoute(RouteDefinition definition) {
        return PreconditionHelper.included(definition, this);
    }

    private static ValueHolder<String> createTransformerKey(TransformerDefinition def) {
        return ObjectHelper.isNotEmpty(def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }
}

