/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLanguageResolver
implements LanguageResolver {
    public static final String LANGUAGE_RESOURCE_PATH = "META-INF/services/org/apache/camel/language/";
    public static final String LANGUAGE_RESOLVER_RESOURCE_PATH = "META-INF/services/org/apache/camel/language/resolver/";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLanguageResolver.class);
    protected FactoryFinder languageFactory;
    protected FactoryFinder languageResolver;

    @Override
    public Language resolveLanguage(String name, CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findLanguage(name, context);
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Language registered for scheme: " + name, e);
        }
        if (type != null) {
            if (Language.class.isAssignableFrom(type)) {
                return (Language)context.getInjector().newInstance(type, false);
            }
            throw new IllegalArgumentException("Resolving language: " + name + " detected type conflict: Not a Language implementation. Found: " + type.getName());
        }
        return this.noSpecificLanguageFound(name, context);
    }

    protected Language noSpecificLanguageFound(String name, CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findLanguageResolver("default", context);
        }
        catch (NoFactoryAvailableException noFactoryAvailableException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no LanguageResolver registered for scheme: " + name, e);
        }
        if (type != null) {
            if (LanguageResolver.class.isAssignableFrom(type)) {
                LanguageResolver resolver = (LanguageResolver)context.getInjector().newInstance(type, false);
                return resolver.resolveLanguage(name, context);
            }
            throw new IllegalArgumentException("Resolving language: " + name + " detected type conflict: Not a LanguageResolver implementation. Found: " + type.getName());
        }
        throw new NoSuchLanguageException(name);
    }

    protected Class<?> findLanguage(String name, CamelContext context) throws Exception {
        if (this.languageFactory == null) {
            this.languageFactory = context.adapt(ExtendedCamelContext.class).getFactoryFinder(LANGUAGE_RESOURCE_PATH);
        }
        return this.languageFactory.findClass(name).orElse(null);
    }

    protected Class<?> findLanguageResolver(String name, CamelContext context) throws Exception {
        if (this.languageResolver == null) {
            this.languageResolver = context.adapt(ExtendedCamelContext.class).getFactoryFinder(LANGUAGE_RESOLVER_RESOURCE_PATH);
        }
        return this.languageResolver.findClass(name).orElse(null);
    }

    protected Logger getLog() {
        return LOG;
    }
}

