/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.cff.CFFDataReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OTFSubSetWriter;

public class OTFSubSetFile
extends OTFSubSetWriter {
    protected Map<Integer, Integer> subsetGlyphs = new LinkedHashMap<Integer, Integer>();
    protected Map<Integer, Integer> gidToSID;
    protected CFFDataReader.CFFIndexData localIndexSubr;
    protected CFFDataReader.CFFIndexData globalIndexSubr;
    protected List<byte[]> subsetLocalIndexSubr;
    protected List<byte[]> subsetGlobalIndexSubr;
    protected List<List<byte[]>> fdSubrs;
    private Map<Integer, FDIndexReference> subsetFDSelect;
    protected List<Integer> localUniques;
    protected List<Integer> globalUniques;
    protected int subsetLocalSubrCount;
    protected int subsetGlobalSubrCount;
    protected List<byte[]> subsetCharStringsIndex;
    protected String embeddedName;
    protected List<byte[]> stringIndexData = new ArrayList<byte[]>();
    protected CFFDataReader cffReader;
    private MultiByteFont mbFont;
    public static final int NUM_STANDARD_STRINGS = 391;
    private static final int LOCAL_SUBROUTINE = 10;
    private static final int GLOBAL_SUBROUTINE = 29;
    private Type2Parser type2Parser;

    @Override
    public void readFont(FontFileReader in, String embeddedName, MultiByteFont mbFont) throws IOException {
        this.readFont(in, embeddedName, mbFont, mbFont.getUsedGlyphs());
    }

    void readFont(FontFileReader in, String embeddedName, MultiByteFont mbFont, Map<Integer, Integer> usedGlyphs) throws IOException {
        this.mbFont = mbFont;
        this.fontFile = in;
        this.embeddedName = embeddedName;
        this.subsetGlyphs = this.sortByValue(usedGlyphs);
        this.initializeFont(in);
        this.cffReader = new CFFDataReader(this.fontFile);
        this.createCFF();
    }

    private Map<Integer, Integer> sortByValue(Map<Integer, Integer> map) {
        ArrayList<Map.Entry<Integer, Integer>> list = new ArrayList<Map.Entry<Integer, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry entry : list) {
            result.put((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    protected void createCFF() throws IOException {
        boolean hasFDSelect;
        this.writeBytes(this.cffReader.getHeader());
        this.writeIndex(Arrays.asList(new byte[][]{this.embedFontName.getBytes("UTF-8")}));
        Offsets offsets = new Offsets();
        offsets.topDictData = this.currentPos + this.writeTopDICT();
        boolean bl = hasFDSelect = this.cffReader.getFDSelect() != null;
        if (hasFDSelect) {
            this.createCharStringDataCID();
        } else {
            this.createCharStringData();
        }
        List<Integer> fontNameSIDs = null;
        List<Integer> subsetFDFonts = null;
        if (hasFDSelect) {
            subsetFDFonts = this.getUsedFDFonts();
            fontNameSIDs = this.storeFDStrings(subsetFDFonts);
        }
        this.writeStringIndex();
        this.writeIndex(this.subsetGlobalIndexSubr);
        offsets.encoding = this.currentPos;
        offsets.charset = this.currentPos;
        this.writeCharsetTable(hasFDSelect);
        offsets.fdSelect = this.currentPos;
        if (hasFDSelect) {
            this.writeFDSelect();
            if (!this.isCharStringBeforeFD()) {
                offsets.fdArray = this.writeFDArray(subsetFDFonts, fontNameSIDs);
            }
        }
        offsets.charString = this.currentPos;
        this.writeIndex(this.subsetCharStringsIndex);
        if (hasFDSelect) {
            if (this.isCharStringBeforeFD()) {
                offsets.fdArray = this.writeFDArray(subsetFDFonts, fontNameSIDs);
            }
            this.updateCIDOffsets(offsets);
        } else {
            offsets.privateDict = this.currentPos;
            this.writePrivateDict();
            offsets.localIndex = this.currentPos;
            this.writeIndex(this.subsetLocalIndexSubr);
            this.updateOffsets(offsets);
        }
    }

    private int writeFDArray(List<Integer> subsetFDFonts, List<Integer> fontNameSIDs) throws IOException {
        List<Integer> privateDictOffsets = this.writeCIDDictsAndSubrs(subsetFDFonts);
        return this.writeFDArray(subsetFDFonts, privateDictOffsets, fontNameSIDs);
    }

    private boolean isCharStringBeforeFD() {
        LinkedHashMap<String, CFFDataReader.DICTEntry> entries = this.cffReader.getTopDictEntries();
        int len = entries.get("CharStrings").getOperandLength();
        if (entries.containsKey("FDArray")) {
            int len2 = entries.get("FDArray").getOperandLength();
            return len < len2;
        }
        return true;
    }

    protected List<Integer> storeFDStrings(List<Integer> uniqueNewRefs) throws IOException {
        ArrayList<Integer> fontNameSIDs = new ArrayList<Integer>();
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        for (int uniqueNewRef : uniqueNewRefs) {
            CFFDataReader.FontDict fdFont = fdFonts.get(uniqueNewRef);
            byte[] fdFontByteData = fdFont.getByteData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdFontDict = this.cffReader.parseDictData(fdFontByteData);
            fontNameSIDs.add(this.stringIndexData.size() + 391);
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOperands().get(0).intValue() - 391));
        }
        return fontNameSIDs;
    }

    protected int writeTopDICT() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        List<String> topDictStringEntries = Arrays.asList("version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "PostScript");
        ByteArrayOutputStream dict = new ByteArrayOutputStream();
        int offsetExtra = 0;
        for (Map.Entry dictEntry : topDICT.entrySet()) {
            String dictKey = (String)dictEntry.getKey();
            CFFDataReader.DICTEntry entry = (CFFDataReader.DICTEntry)dictEntry.getValue();
            entry.setOffset(entry.getOffset() + offsetExtra);
            if (dictKey.equals("CharStrings") && entry.getOperandLength() < 5) {
                byte[] extra = new byte[5 - entry.getOperandLength()];
                offsetExtra += extra.length;
                dict.write(extra);
                dict.write(entry.getByteData());
                entry.setOperandLength(5);
                continue;
            }
            if (dictKey.equals("ROS")) {
                dict.write(this.writeROSEntry(entry));
                continue;
            }
            if (dictKey.equals("CIDCount")) {
                dict.write(this.writeCIDCount(entry));
                continue;
            }
            if (topDictStringEntries.contains(dictKey)) {
                if (entry.getOperandLength() < 2) {
                    entry.setOperandLength(2);
                    ++offsetExtra;
                }
                dict.write(this.writeTopDictStringEntry(entry));
                continue;
            }
            dict.write(entry.getByteData());
        }
        byte[] topDictIndex = this.cffReader.getTopDictIndex().getByteData();
        byte offSize = topDictIndex[2];
        return this.writeIndex(Arrays.asList(new byte[][]{dict.toByteArray()}), offSize) - dict.size();
    }

    private byte[] writeROSEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sidA = dictEntry.getOperands().get(0).intValue();
        if (sidA > 390) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sidA - 391));
        }
        int sidAStringIndex = this.stringIndexData.size() + 390;
        int sidB = dictEntry.getOperands().get(1).intValue();
        if (sidB > 390) {
            this.stringIndexData.add("Identity".getBytes("UTF-8"));
        }
        int sidBStringIndex = this.stringIndexData.size() + 390;
        byte[] cidEntryByteData = dictEntry.getByteData();
        this.updateOffset(cidEntryByteData, 0, dictEntry.getOperandLengths().get(0), sidAStringIndex);
        this.updateOffset(cidEntryByteData, dictEntry.getOperandLengths().get(0), dictEntry.getOperandLengths().get(1), sidBStringIndex);
        this.updateOffset(cidEntryByteData, dictEntry.getOperandLengths().get(0) + dictEntry.getOperandLengths().get(1), dictEntry.getOperandLengths().get(2), 0);
        return cidEntryByteData;
    }

    protected byte[] writeCIDCount(CFFDataReader.DICTEntry dictEntry) throws IOException {
        byte[] cidCountByteData = dictEntry.getByteData();
        this.updateOffset(cidCountByteData, 0, dictEntry.getOperandLengths().get(0), this.subsetGlyphs.size());
        return cidCountByteData;
    }

    private byte[] writeTopDictStringEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sid = dictEntry.getOperands().get(0).intValue();
        if (sid > 391) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sid - 391));
        }
        byte[] newDictEntry = OTFSubSetFile.createNewRef(this.stringIndexData.size() + 390, dictEntry.getOperator(), dictEntry.getOperandLength(), true);
        return newDictEntry;
    }

    private void writeStringIndex() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        int charsetOffset = ((CFFDataReader.DICTEntry)topDICT.get("charset")).getOperands().get(0).intValue();
        this.gidToSID = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> subsetGlyph : this.subsetGlyphs.entrySet()) {
            int gid = subsetGlyph.getKey();
            int v = subsetGlyph.getValue();
            int sid = this.cffReader.getSIDFromGID(charsetOffset, gid);
            if (sid < 391) {
                this.gidToSID.put(v, sid);
                if (this.mbFont == null) continue;
                this.mbFont.mapUsedGlyphName(v, CFFStandardString.getName(sid));
                continue;
            }
            int index = sid - 391;
            if (index < this.cffReader.getStringIndex().getNumObjects()) {
                byte[] value = this.cffReader.getStringIndex().getValue(index);
                if (this.mbFont != null) {
                    this.mbFont.mapUsedGlyphName(v, new String(value, "UTF-8"));
                }
                this.gidToSID.put(v, this.stringIndexData.size() + 391);
                this.stringIndexData.add(value);
                continue;
            }
            if (this.mbFont != null) {
                this.mbFont.mapUsedGlyphName(v, ".notdef");
            }
            this.gidToSID.put(v, index);
        }
        this.writeIndex(this.stringIndexData);
    }

    protected void createCharStringDataCID() throws IOException {
        CFFDataReader.CFFIndexData charStringsIndex = this.cffReader.getCharStringIndex();
        CFFDataReader.FDSelect fontDictionary = this.cffReader.getFDSelect();
        if (fontDictionary instanceof CFFDataReader.Format0FDSelect) {
            throw new UnsupportedOperationException("OTF CFF CID Format0 currently not implemented");
        }
        if (fontDictionary instanceof CFFDataReader.Format3FDSelect) {
            CFFDataReader.Format3FDSelect fdSelect = (CFFDataReader.Format3FDSelect)fontDictionary;
            HashMap<Integer, Integer> subsetGroups = new HashMap<Integer, Integer>();
            ArrayList<Integer> uniqueGroups = new ArrayList<Integer>();
            Map<Integer, Integer> rangeMap = fdSelect.getRanges();
            Integer[] ranges = rangeMap.keySet().toArray(new Integer[rangeMap.size()]);
            for (int gid : this.subsetGlyphs.keySet()) {
                int i = 0;
                for (Map.Entry<Integer, Integer> entry : rangeMap.entrySet()) {
                    int nextRange = i < ranges.length - 1 ? ranges[i + 1].intValue() : fdSelect.getSentinelGID();
                    if (gid >= entry.getKey() && gid < nextRange) {
                        int r = entry.getValue();
                        subsetGroups.put(gid, r);
                        if (!uniqueGroups.contains(r)) {
                            uniqueGroups.add(r);
                        }
                    }
                    ++i;
                }
            }
            this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
            this.subsetCharStringsIndex = new ArrayList<byte[]>();
            this.globalUniques = new ArrayList<Integer>();
            this.subsetFDSelect = new LinkedHashMap<Integer, FDIndexReference>();
            ArrayList foundLocalUniques = new ArrayList();
            Iterator i$ = uniqueGroups.iterator();
            while (i$.hasNext()) {
                int u = (Integer)i$.next();
                foundLocalUniques.add(new ArrayList());
            }
            HashMap<Integer, Integer> gidHintMaskLengths = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : this.subsetGlyphs.entrySet()) {
                int gid = entry.getKey();
                int group = (Integer)subsetGroups.get(gid);
                this.localIndexSubr = this.cffReader.getFDFonts().get(group).getLocalSubrData();
                this.localUniques = (List)foundLocalUniques.get(uniqueGroups.indexOf(group));
                this.type2Parser = new Type2Parser();
                FDIndexReference newFDReference = new FDIndexReference(uniqueGroups.indexOf(group), group);
                this.subsetFDSelect.put(entry.getValue(), newFDReference);
                byte[] data = charStringsIndex.getValue(gid);
                this.preScanForSubsetIndexSize(data);
                gidHintMaskLengths.put(gid, this.type2Parser.getMaskLength());
            }
            this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
            this.fdSubrs = new ArrayList<List<byte[]>>();
            this.subsetGlobalSubrCount = this.globalUniques.size();
            this.globalUniques.clear();
            this.localUniques = null;
            for (List list : foundLocalUniques) {
                this.fdSubrs.add(new ArrayList());
            }
            ArrayList foundLocalUniquesB = new ArrayList();
            Iterator iterator = uniqueGroups.iterator();
            while (iterator.hasNext()) {
                int u = (Integer)iterator.next();
                foundLocalUniquesB.add(new ArrayList());
            }
            for (Map.Entry<Integer, Integer> subsetGlyph : this.subsetGlyphs.entrySet()) {
                int gid = subsetGlyph.getKey();
                int value = subsetGlyph.getValue();
                int group = (Integer)subsetGroups.get(gid);
                this.localIndexSubr = this.cffReader.getFDFonts().get(group).getLocalSubrData();
                int newFDIndex = this.subsetFDSelect.get(value).getNewFDIndex();
                this.localUniques = (List)foundLocalUniquesB.get(newFDIndex);
                byte[] data = charStringsIndex.getValue(gid);
                this.subsetLocalIndexSubr = this.fdSubrs.get(newFDIndex);
                this.subsetLocalSubrCount = ((List)foundLocalUniques.get(newFDIndex)).size();
                this.type2Parser = new Type2Parser();
                this.type2Parser.setMaskLength((Integer)gidHintMaskLengths.get(gid));
                data = this.readCharStringData(data, this.subsetLocalSubrCount);
                this.subsetCharStringsIndex.add(data);
            }
        }
    }

    protected void writeFDSelect() {
        if (this.cffReader.getTopDictEntries().get("CharStrings").getOperandLength() == 2) {
            Map<Integer, Integer> indexs = this.getFormat3Index();
            this.writeByte(3);
            this.writeCard16(indexs.size());
            int count = 0;
            for (Map.Entry<Integer, Integer> x : indexs.entrySet()) {
                this.writeCard16(count);
                this.writeByte(x.getKey());
                count += x.getValue().intValue();
            }
            this.writeCard16(this.subsetFDSelect.size());
        } else {
            this.writeByte(0);
            for (FDIndexReference e : this.subsetFDSelect.values()) {
                this.writeByte(e.getNewFDIndex());
            }
        }
    }

    private Map<Integer, Integer> getFormat3Index() {
        LinkedHashMap<Integer, Integer> indexs = new LinkedHashMap<Integer, Integer>();
        int last = -1;
        int count = 0;
        for (FDIndexReference e : this.subsetFDSelect.values()) {
            int i = e.getNewFDIndex();
            ++count;
            if (i != last) {
                indexs.put(i, count);
                count = 1;
            }
            last = i;
        }
        indexs.put(last, count);
        return indexs;
    }

    protected List<Integer> getUsedFDFonts() {
        ArrayList<Integer> uniqueNewRefs = new ArrayList<Integer>();
        for (FDIndexReference e : this.subsetFDSelect.values()) {
            int fdIndex = e.getOldFDIndex();
            if (uniqueNewRefs.contains(fdIndex)) continue;
            uniqueNewRefs.add(fdIndex);
        }
        return uniqueNewRefs;
    }

    protected List<Integer> writeCIDDictsAndSubrs(List<Integer> uniqueNewRefs) throws IOException {
        ArrayList<Integer> privateDictOffsets = new ArrayList<Integer>();
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        int i = 0;
        for (int ref : uniqueNewRefs) {
            CFFDataReader.FontDict curFDFont = fdFonts.get(ref);
            byte[] fdPrivateDictByteData = curFDFont.getPrivateDictData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdPrivateDict = this.cffReader.parseDictData(fdPrivateDictByteData);
            int privateDictOffset = this.currentPos;
            privateDictOffsets.add(privateDictOffset);
            CFFDataReader.DICTEntry subrs = (CFFDataReader.DICTEntry)fdPrivateDict.get("Subrs");
            if (subrs != null) {
                fdPrivateDictByteData = this.resizeToFitOpLen(fdPrivateDictByteData, subrs);
                this.updateOffset(fdPrivateDictByteData, subrs.getOffset(), subrs.getOperandLength(), fdPrivateDictByteData.length);
            }
            this.writeBytes(fdPrivateDictByteData);
            this.writeIndex(this.fdSubrs.get(i));
            ++i;
        }
        return privateDictOffsets;
    }

    private byte[] resizeToFitOpLen(byte[] fdPrivateDictByteData, CFFDataReader.DICTEntry subrs) throws IOException {
        if (subrs.getOperandLength() == 2 && fdPrivateDictByteData.length < 108) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(fdPrivateDictByteData);
            bos.write(new byte[108 - fdPrivateDictByteData.length]);
            fdPrivateDictByteData = bos.toByteArray();
        }
        return fdPrivateDictByteData;
    }

    protected int writeFDArray(List<Integer> uniqueNewRefs, List<Integer> privateDictOffsets, List<Integer> fontNameSIDs) throws IOException {
        int offset = this.currentPos;
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        ArrayList<byte[]> index = new ArrayList<byte[]>();
        int i = 0;
        for (int ref : uniqueNewRefs) {
            CFFDataReader.FontDict fdFont = fdFonts.get(ref);
            byte[] fdFontByteData = fdFont.getByteData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdFontDict = this.cffReader.parseDictData(fdFontByteData);
            this.updateOffset(fdFontByteData, ((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOffset() - 1, ((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOperandLengths().get(0), fontNameSIDs.get(i));
            this.updateOffset(fdFontByteData, ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOffset() + ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOperandLengths().get(0), ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOperandLengths().get(1), privateDictOffsets.get(i));
            index.add(fdFontByteData);
            ++i;
        }
        this.writeIndex(index);
        return offset;
    }

    private void createCharStringData() throws IOException {
        byte[] data;
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.CFFIndexData charStringsIndex = this.cffReader.getCharStringIndex();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            int privateOffset = privateEntry.getOperands().get(1).intValue();
            Map<String, CFFDataReader.DICTEntry> privateDICT = this.cffReader.getPrivateDict(privateEntry);
            if (privateDICT.get("Subrs") != null) {
                int localSubrOffset = privateOffset + privateDICT.get("Subrs").getOperands().get(0).intValue();
                this.localIndexSubr = this.cffReader.readIndex(localSubrOffset);
            } else {
                this.localIndexSubr = this.cffReader.readIndex(null);
            }
        }
        this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
        this.subsetLocalIndexSubr = new ArrayList<byte[]>();
        this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
        this.subsetCharStringsIndex = new ArrayList<byte[]>();
        this.localUniques = new ArrayList<Integer>();
        this.globalUniques = new ArrayList<Integer>();
        HashMap<Integer, Integer> gidHintMaskLengths = new HashMap<Integer, Integer>();
        for (int gid : this.subsetGlyphs.keySet()) {
            this.type2Parser = new Type2Parser();
            data = charStringsIndex.getValue(gid);
            this.preScanForSubsetIndexSize(data);
            gidHintMaskLengths.put(gid, this.type2Parser.getMaskLength());
        }
        this.subsetLocalSubrCount = this.localUniques.size();
        this.subsetGlobalSubrCount = this.globalUniques.size();
        this.localUniques.clear();
        this.globalUniques.clear();
        for (int gid : this.subsetGlyphs.keySet()) {
            data = charStringsIndex.getValue(gid);
            this.type2Parser = new Type2Parser();
            this.type2Parser.setMaskLength((Integer)gidHintMaskLengths.get(gid));
            data = this.readCharStringData(data, this.subsetLocalSubrCount);
            this.subsetCharStringsIndex.add(data);
        }
    }

    private void preScanForSubsetIndexSize(byte[] data) throws IOException {
        boolean hasLocalSubroutines = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean hasGlobalSubroutines = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        for (int dataPos = 0; dataPos < data.length; ++dataPos) {
            int b0 = data[dataPos] & 0xFF;
            if (b0 == 10 && hasLocalSubroutines) {
                this.preScanForSubsetIndexSize(this.localIndexSubr, this.localUniques);
                continue;
            }
            if (b0 == 29 && hasGlobalSubroutines) {
                this.preScanForSubsetIndexSize(this.globalIndexSubr, this.globalUniques);
                continue;
            }
            dataPos += this.type2Parser.exec(b0, data, dataPos);
        }
    }

    private void preScanForSubsetIndexSize(CFFDataReader.CFFIndexData indexSubr, List<Integer> uniques) throws IOException {
        int subrNumber = this.getSubrNumber(indexSubr.getNumObjects(), this.type2Parser.popOperand().getNumber());
        if (!uniques.contains(subrNumber) && subrNumber < indexSubr.getNumObjects()) {
            uniques.add(subrNumber);
        }
        if (subrNumber >= indexSubr.getNumObjects()) {
            throw new IllegalArgumentException("callgsubr out of range");
        }
        byte[] subr = indexSubr.getValue(subrNumber);
        this.preScanForSubsetIndexSize(subr);
    }

    private int getSubrNumber(int numSubroutines, int operand) {
        int bias = this.getBias(numSubroutines);
        return bias + operand;
    }

    private byte[] readCharStringData(byte[] data, int subsetLocalSubrCount) throws IOException {
        boolean hasLocalSubroutines = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean hasGlobalSubroutines = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        for (int dataPos = 0; dataPos < data.length; ++dataPos) {
            byte[] newData;
            int newRef;
            int subrNumber;
            BytesNumber operand;
            int b0 = data[dataPos] & 0xFF;
            if (b0 == 10 && hasLocalSubroutines) {
                operand = this.type2Parser.popOperand();
                subrNumber = this.getSubrNumber(this.localIndexSubr.getNumObjects(), operand.getNumber());
                newRef = this.getNewRefForReference(subrNumber, this.localUniques, this.localIndexSubr, this.subsetLocalIndexSubr, subsetLocalSubrCount);
                if (newRef == -1) continue;
                newData = this.constructNewRefData(dataPos, data, operand, subsetLocalSubrCount, newRef, new int[]{10});
                dataPos -= data.length - newData.length;
                data = newData;
                continue;
            }
            if (b0 == 29 && hasGlobalSubroutines) {
                operand = this.type2Parser.popOperand();
                subrNumber = this.getSubrNumber(this.globalIndexSubr.getNumObjects(), operand.getNumber());
                newRef = this.getNewRefForReference(subrNumber, this.globalUniques, this.globalIndexSubr, this.subsetGlobalIndexSubr, this.subsetGlobalSubrCount);
                if (newRef == -1) continue;
                newData = this.constructNewRefData(dataPos, data, operand, this.subsetGlobalSubrCount, newRef, new int[]{29});
                dataPos -= data.length - newData.length;
                data = newData;
                continue;
            }
            dataPos += this.type2Parser.exec(b0, data, dataPos);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getNewRefForReference(int subrNumber, List<Integer> uniquesArray, CFFDataReader.CFFIndexData indexSubr, List<byte[]> subsetIndexSubr, int subrCount) throws IOException {
        if (uniquesArray.contains(subrNumber)) return uniquesArray.indexOf(subrNumber);
        if (subrNumber >= indexSubr.getNumObjects()) throw new IllegalArgumentException("subrNumber out of range");
        byte[] subr = indexSubr.getValue(subrNumber);
        subr = this.readCharStringData(subr, subrCount);
        uniquesArray.add(subrNumber);
        subsetIndexSubr.add(subr);
        return subsetIndexSubr.size() - 1;
    }

    private int getBias(int subrCount) {
        if (subrCount < 1240) {
            return 107;
        }
        if (subrCount < 33900) {
            return 1131;
        }
        return 32768;
    }

    private byte[] constructNewRefData(int curDataPos, byte[] currentData, BytesNumber operand, int fullSubsetIndexSize, int curSubsetIndexSize, int[] operatorCode) throws IOException {
        ByteArrayOutputStream newData = new ByteArrayOutputStream();
        int startRef = curDataPos - operand.getNumBytes();
        int length = operand.getNumBytes() + 1;
        int newBias = this.getBias(fullSubsetIndexSize);
        int newRef = curSubsetIndexSize - newBias;
        byte[] newRefBytes = OTFSubSetFile.createNewRef(newRef, operatorCode, -1, false);
        newData.write(currentData, 0, startRef);
        newData.write(newRefBytes);
        newData.write(currentData, startRef + length, currentData.length - (startRef + length));
        return newData.toByteArray();
    }

    public static byte[] createNewRef(int newRef, int[] operatorCode, int forceLength, boolean isDict) {
        ByteArrayOutputStream newRefBytes = new ByteArrayOutputStream();
        if (forceLength == -1 && newRef >= -107 && newRef <= 107 || forceLength == 1) {
            newRefBytes.write(newRef + 139);
        } else if (forceLength == -1 && newRef >= -1131 && newRef <= 1131 || forceLength == 2) {
            if (newRef <= -876) {
                newRefBytes.write(254);
            } else if (newRef <= -620) {
                newRefBytes.write(253);
            } else if (newRef <= -364) {
                newRefBytes.write(252);
            } else if (newRef <= -108) {
                newRefBytes.write(251);
            } else if (newRef <= 363) {
                newRefBytes.write(247);
            } else if (newRef <= 619) {
                newRefBytes.write(248);
            } else if (newRef <= 875) {
                newRefBytes.write(249);
            } else {
                newRefBytes.write(250);
            }
            if (newRef > 0) {
                newRefBytes.write(newRef - 108);
            } else {
                newRefBytes.write(-newRef - 108);
            }
        } else if (forceLength == -1 && newRef >= Short.MIN_VALUE && newRef <= Short.MAX_VALUE || forceLength == 3) {
            newRefBytes.write(28);
            newRefBytes.write(newRef >> 8);
            newRefBytes.write(newRef);
        } else {
            if (isDict) {
                newRefBytes.write(29);
            } else {
                newRefBytes.write(255);
            }
            newRefBytes.write(newRef >> 24);
            newRefBytes.write(newRef >> 16);
            newRefBytes.write(newRef >> 8);
            newRefBytes.write(newRef);
        }
        for (int i : operatorCode) {
            newRefBytes.write(i);
        }
        return newRefBytes.toByteArray();
    }

    protected int writeIndex(List<byte[]> dataArray) {
        int totLength = 1;
        for (byte[] data : dataArray) {
            totLength += data.length;
        }
        int offSize = this.getOffSize(totLength);
        return this.writeIndex(dataArray, offSize);
    }

    protected int writeIndex(List<byte[]> dataArray, int offSize) {
        int hdrTotal = 3;
        this.writeCard16(dataArray.size());
        this.writeByte(offSize);
        hdrTotal += offSize;
        int total = 0;
        int i = 0;
        for (byte[] data : dataArray) {
            hdrTotal += offSize;
            int length = data.length;
            switch (offSize) {
                case 1: {
                    if (i == 0) {
                        this.writeByte(1);
                    }
                    this.writeByte((total += length) + 1);
                    break;
                }
                case 2: {
                    if (i == 0) {
                        this.writeCard16(1);
                    }
                    this.writeCard16((total += length) + 1);
                    break;
                }
                case 3: {
                    if (i == 0) {
                        this.writeThreeByteNumber(1);
                    }
                    this.writeThreeByteNumber((total += length) + 1);
                    break;
                }
                case 4: {
                    if (i == 0) {
                        this.writeULong(1);
                    }
                    this.writeULong((total += length) + 1);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Offset Size was not an expected value.");
                }
            }
            ++i;
        }
        for (byte[] aDataArray : dataArray) {
            this.writeBytes(aDataArray);
        }
        return hdrTotal + total;
    }

    private int getOffSize(int totLength) {
        int offSize = 1;
        offSize = totLength < 256 ? 1 : (totLength < 65536 ? 2 : (totLength < 0x1000000 ? 3 : 4));
        return offSize;
    }

    private void writeCharsetTable(boolean cidFont) throws IOException {
        if (cidFont) {
            this.writeByte(2);
            for (int entry : this.gidToSID.keySet()) {
                if (entry == 0) continue;
                this.writeCard16(entry);
                this.writeCard16(this.gidToSID.size() - 1);
                break;
            }
        } else {
            this.writeByte(0);
            for (int entry : this.gidToSID.values()) {
                if (entry == 0) continue;
                this.writeCard16(entry);
            }
        }
    }

    protected void writePrivateDict() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            this.writeBytes(this.cffReader.getPrivateDictBytes(privateEntry));
        }
    }

    protected void updateOffsets(Offsets offsets) throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        Map<String, CFFDataReader.DICTEntry> privateDICT = null;
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            privateDICT = this.cffReader.getPrivateDict(privateEntry);
        }
        this.updateFixedOffsets(topDICT, offsets);
        if (privateDICT != null) {
            int oldPrivateOffset = offsets.topDictData + privateEntry.getOffset();
            this.updateOffset(oldPrivateOffset + privateEntry.getOperandLengths().get(0), privateEntry.getOperandLengths().get(1), offsets.privateDict);
            CFFDataReader.DICTEntry subroutines = privateDICT.get("Subrs");
            if (subroutines != null) {
                int oldLocalSubrOffset = offsets.privateDict + subroutines.getOffset();
                this.updateOffset(oldLocalSubrOffset, subroutines.getOperandLength(), offsets.localIndex - offsets.privateDict);
            }
        }
    }

    protected void updateFixedOffsets(Map<String, CFFDataReader.DICTEntry> topDICT, Offsets offsets) throws IOException {
        CFFDataReader.DICTEntry charset = topDICT.get("charset");
        int oldCharsetOffset = offsets.topDictData + charset.getOffset();
        this.updateOffset(oldCharsetOffset, charset.getOperandLength(), offsets.charset);
        CFFDataReader.DICTEntry charString = topDICT.get("CharStrings");
        int oldCharStringOffset = offsets.topDictData + charString.getOffset();
        this.updateOffset(oldCharStringOffset, charString.getOperandLength(), offsets.charString);
        CFFDataReader.DICTEntry encodingEntry = topDICT.get("Encoding");
        if (encodingEntry != null && encodingEntry.getOperands().get(0).intValue() != 0 && encodingEntry.getOperands().get(0).intValue() != 1) {
            int oldEncodingOffset = offsets.topDictData + encodingEntry.getOffset();
            this.updateOffset(oldEncodingOffset, encodingEntry.getOperandLength(), offsets.encoding);
        }
    }

    protected void updateCIDOffsets(Offsets offsets) throws IOException {
        CFFDataReader.DICTEntry fdSelect;
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDict = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry fdArrayEntry = (CFFDataReader.DICTEntry)topDict.get("FDArray");
        if (fdArrayEntry != null) {
            this.updateOffset(offsets.topDictData + fdArrayEntry.getOffset() - 1, fdArrayEntry.getOperandLength(), offsets.fdArray);
        }
        if ((fdSelect = (CFFDataReader.DICTEntry)topDict.get("FDSelect")) != null) {
            this.updateOffset(offsets.topDictData + fdSelect.getOffset() - 1, fdSelect.getOperandLength(), offsets.fdSelect);
        }
        this.updateFixedOffsets(topDict, offsets);
    }

    private void updateOffset(int position, int length, int replacement) throws IOException {
        byte[] outBytes = this.output.toByteArray();
        this.updateOffset(outBytes, position, length, replacement);
        this.output.reset();
        this.output.write(outBytes);
    }

    private void updateOffset(byte[] out, int position, int length, int replacement) {
        switch (length) {
            case 1: {
                out[position] = (byte)(replacement + 139);
                break;
            }
            case 2: {
                assert (replacement <= 1131);
                out[position] = replacement <= -876 ? -2 : (replacement <= -620 ? -3 : (replacement <= -364 ? -4 : (replacement <= -108 ? -5 : (replacement <= 363 ? -9 : (replacement <= 619 ? -8 : (replacement <= 875 ? -7 : -6))))));
                if (replacement > 0) {
                    out[position + 1] = (byte)(replacement - 108);
                    break;
                }
                out[position + 1] = (byte)(-replacement - 108);
                break;
            }
            case 3: {
                assert (replacement <= Short.MAX_VALUE);
                out[position] = 28;
                out[position + 1] = (byte)(replacement >> 8 & 0xFF);
                out[position + 2] = (byte)(replacement & 0xFF);
                break;
            }
            case 5: {
                out[position] = 29;
                out[position + 1] = (byte)(replacement >> 24 & 0xFF);
                out[position + 2] = (byte)(replacement >> 16 & 0xFF);
                out[position + 3] = (byte)(replacement >> 8 & 0xFF);
                out[position + 4] = (byte)(replacement & 0xFF);
                break;
            }
        }
    }

    public CFFDataReader getCFFReader() {
        return this.cffReader;
    }

    static class BytesNumber {
        private int number;
        private int numBytes;

        public BytesNumber(int number, int numBytes) {
            this.number = number;
            this.numBytes = numBytes;
        }

        public int getNumber() {
            return this.number;
        }

        public int getNumBytes() {
            return this.numBytes;
        }

        public void clearNumber() {
            this.number = -1;
            this.numBytes = -1;
        }

        public String toString() {
            return Integer.toString(this.number);
        }

        public boolean equals(Object entry) {
            assert (entry instanceof BytesNumber);
            BytesNumber bnEntry = (BytesNumber)entry;
            return this.number == bnEntry.getNumber() && this.numBytes == bnEntry.getNumBytes();
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.number;
            hash = hash * 31 + this.numBytes;
            return hash;
        }
    }

    static class Type2Parser {
        protected Log log = LogFactory.getLog(Type2Parser.class);
        private List<BytesNumber> stack = new ArrayList<BytesNumber>();
        private int hstemCount;
        private int vstemCount;
        private int lastOp = -1;
        private int maskLength = -1;

        Type2Parser() {
        }

        public void pushOperand(BytesNumber v) {
            this.stack.add(v);
        }

        public BytesNumber popOperand() {
            return this.stack.remove(this.stack.size() - 1);
        }

        public void clearStack() {
            this.stack.clear();
        }

        public int[] getOperands(int numbers) {
            int[] ret = new int[numbers];
            while (numbers > 0) {
                ret[--numbers] = this.popOperand().getNumber();
            }
            return ret;
        }

        public void setMaskLength(int maskLength) {
            this.maskLength = maskLength;
        }

        public int getMaskLength() {
            if (this.maskLength > 0) {
                return this.maskLength;
            }
            return 1 + (this.hstemCount + this.vstemCount - 1) / 8;
        }

        private int exec(int b0, byte[] input, int curPos) throws IOException {
            ByteArrayInputStream bis = new ByteArrayInputStream(input);
            bis.skip(curPos + 1);
            return this.exec(b0, bis);
        }

        public int exec(int b0, InputStream data) throws IOException {
            int posDelta = 0;
            if (b0 >= 0 && b0 <= 27 || b0 >= 29 && b0 <= 31) {
                if (b0 == 12) {
                    this.log.warn((Object)"May not guess the operand count correctly.");
                    posDelta = 1;
                } else if (b0 == 1 || b0 == 18) {
                    this.hstemCount += this.stack.size() / 2;
                    this.clearStack();
                } else if (b0 == 19 || b0 == 20) {
                    if (this.lastOp == 1 || this.lastOp == 18) {
                        this.vstemCount += this.stack.size() / 2;
                    }
                    this.clearStack();
                    posDelta = this.getMaskLength();
                } else if (b0 == 3 || b0 == 23) {
                    this.vstemCount += this.stack.size() / 2;
                    this.clearStack();
                }
                if (b0 != 11 && b0 != 12) {
                    this.lastOp = b0;
                }
            } else if (b0 == 28 || b0 >= 32 && b0 <= 255) {
                BytesNumber operand = this.readNumber(b0, data);
                this.pushOperand(operand);
                posDelta = operand.getNumBytes() - 1;
            } else {
                throw new UnsupportedOperationException("Operator:" + b0 + " is not supported");
            }
            return posDelta;
        }

        private BytesNumber readNumber(int b0, InputStream input) throws IOException {
            if (b0 == 28) {
                int b1 = input.read();
                int b2 = input.read();
                return new BytesNumber((short)(b1 << 8 | b2), 3);
            }
            if (b0 >= 32 && b0 <= 246) {
                return new BytesNumber(b0 - 139, 1);
            }
            if (b0 >= 247 && b0 <= 250) {
                int b1 = input.read();
                return new BytesNumber((b0 - 247) * 256 + b1 + 108, 2);
            }
            if (b0 >= 251 && b0 <= 254) {
                int b1 = input.read();
                return new BytesNumber(-(b0 - 251) * 256 - b1 - 108, 2);
            }
            if (b0 == 255) {
                int b1 = input.read();
                int b2 = input.read();
                int b3 = input.read();
                int b4 = input.read();
                return new BytesNumber(b1 << 24 | b2 << 16 | b3 << 8 | b4, 5);
            }
            throw new IllegalArgumentException();
        }
    }

    private static class FDIndexReference {
        private int newFDIndex;
        private int oldFDIndex;

        public FDIndexReference(int newFDIndex, int oldFDIndex) {
            this.newFDIndex = newFDIndex;
            this.oldFDIndex = oldFDIndex;
        }

        public int getNewFDIndex() {
            return this.newFDIndex;
        }

        public int getOldFDIndex() {
            return this.oldFDIndex;
        }
    }

    static class Offsets {
        Integer topDictData;
        Integer encoding;
        Integer charset;
        Integer fdSelect;
        Integer charString;
        Integer fdArray;
        Integer privateDict;
        Integer localIndex;

        Offsets() {
        }
    }
}

