/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate.extensions;

import java.awt.Point;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GoToXYAction
extends AbstractAction
implements DocumentNavigationExtensionConstants {
    private int pageIndex = -1;
    private Point targetLocation;

    public GoToXYAction(String id) {
        this(id, -1, null);
    }

    public GoToXYAction(String id, int pageIndex, Point targetLocation) {
        this.setID(id);
        if (pageIndex < 0 && targetLocation != null) {
            throw new IllegalArgumentException("Page index may not be null if target location is known!");
        }
        this.setPageIndex(pageIndex);
        this.setTargetLocation(targetLocation);
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageIndex() {
        if (this.pageIndex >= 0) {
            return this.pageIndex;
        }
        return 0;
    }

    public Point getTargetLocation() {
        if (this.targetLocation == null) {
            return new Point(0, 0);
        }
        return this.targetLocation;
    }

    public void setTargetLocation(Point location) {
        this.targetLocation = location;
    }

    private boolean isCompleteExceptTargetLocation() {
        return this.getPageIndex() >= 0;
    }

    @Override
    public boolean isComplete() {
        return this.isCompleteExceptTargetLocation() && this.targetLocation != null;
    }

    @Override
    public boolean isSame(AbstractAction other) {
        if (other == null) {
            throw new NullPointerException("other must not be null");
        }
        if (!(other instanceof GoToXYAction)) {
            return false;
        }
        GoToXYAction otherAction = (GoToXYAction)other;
        if (this.pageIndex != otherAction.pageIndex) {
            return false;
        }
        if (this.targetLocation == null || otherAction.targetLocation == null) {
            return false;
        }
        return this.getTargetLocation().equals(otherAction.getTargetLocation());
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (this.isCompleteExceptTargetLocation()) {
            Point reportedTargetLocation = this.getTargetLocation();
            atts.addAttribute("", "id", "id", "CDATA", this.getID());
            atts.addAttribute("", "page-index", "page-index", "CDATA", Integer.toString(this.pageIndex));
            atts.addAttribute("", "x", "x", "CDATA", Integer.toString(reportedTargetLocation.x));
            atts.addAttribute("", "y", "y", "CDATA", Integer.toString(reportedTargetLocation.y));
        } else {
            atts.addAttribute("", "idref", "idref", "CDATA", this.getID());
        }
        handler.startElement(GOTO_XY.getNamespaceURI(), GOTO_XY.getLocalName(), GOTO_XY.getQName(), atts);
        handler.endElement(GOTO_XY.getNamespaceURI(), GOTO_XY.getLocalName(), GOTO_XY.getQName());
    }

    public String toString() {
        return "GoToXY: ID=" + this.getID() + ", page=" + this.getPageIndex() + ", loc=" + this.getTargetLocation() + ", " + (this.isComplete() ? "complete" : "INCOMPLETE");
    }
}

