/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.DCTFilter;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class ImageRawJPEGAdapter
extends AbstractImageAdapter {
    private PDFFilter pdfFilter;

    public ImageRawJPEGAdapter(ImageRawJPEG image, String key) {
        super(image, key);
    }

    public ImageRawJPEG getImage() {
        return (ImageRawJPEG)this.image;
    }

    @Override
    public void setup(PDFDocument doc) {
        this.pdfFilter = new DCTFilter();
        this.pdfFilter.setApplied(true);
        super.setup(doc);
    }

    @Override
    public PDFDeviceColorSpace getColorSpace() {
        return ImageRawJPEGAdapter.toPDFColorSpace(this.getImageColorSpace());
    }

    @Override
    public int getBitsPerComponent() {
        return 8;
    }

    @Override
    public boolean isInverted() {
        return this.getImage().isInverted();
    }

    @Override
    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void outputContents(OutputStream out) throws IOException {
        in = this.getImage().createInputStream();
        in = ImageUtil.decorateMarkSupported(in);
        try {
            jpeg = new JPEGFile(in);
            din = jpeg.getDataInput();
            block12: while (true) {
                segID = jpeg.readMarkerSegment();
                switch (segID) {
                    case 216: {
                        out.write(255);
                        out.write(segID);
                        continue block12;
                    }
                    case 217: 
                    case 218: {
                        out.write(255);
                        out.write(segID);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        return;
                    }
                    case 226: {
                        skipICCProfile = false;
                        in.mark(16);
                        try {
                            reclen = jpeg.readSegmentLength();
                            iccString = new byte[11];
                            din.readFully(iccString);
                            if (din.skipBytes(1) != 1) {
                                throw new IOException("premature EOF when skipping terminator byte");
                            }
                            if ("ICC_PROFILE".equals(new String(iccString, "US-ASCII"))) {
                                skipICCProfile = this.image.getICCProfile() != null;
                            }
                        }
                        finally {
                            in.reset();
                        }
                        if (!skipICCProfile) break;
                        jpeg.skipCurrentMarkerSegment();
                        continue block12;
                    }
                }
                out.write(255);
                out.write(segID);
                reclen = jpeg.readSegmentLength();
                out.write(reclen >>> 8 & 255);
                out.write(reclen >>> 0 & 255);
                left = reclen - 2;
                buf = new byte[2048];
                while (true) {
                    if (left > 0) ** break;
                    continue block12;
                    part = Math.min(buf.length, left);
                    din.readFully(buf, 0, part);
                    out.write(buf, 0, part);
                    left -= part;
                }
                break;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public String getFilterHint() {
        return "jpeg";
    }
}

