/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.EnvironmentProfile;
import org.apache.fop.apps.EnvironmentalProfileFactory;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryConfig;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageSessionContext;
import org.apache.xmlgraphics.io.ResourceResolver;

public final class FopFactoryBuilder {
    private final FopFactoryConfig config;
    private FopFactoryConfigBuilder fopFactoryConfigBuilder;

    public FopFactoryBuilder(URI defaultBaseURI) {
        this(defaultBaseURI, ResourceResolverFactory.createDefaultResourceResolver());
    }

    public FopFactoryBuilder(URI defaultBaseURI, ResourceResolver resourceResolver) {
        this(EnvironmentalProfileFactory.createDefault(defaultBaseURI, resourceResolver));
    }

    public FopFactoryBuilder(EnvironmentProfile enviro) {
        this.config = new FopFactoryConfigImpl(enviro);
        this.fopFactoryConfigBuilder = new ActiveFopFactoryConfigBuilder((FopFactoryConfigImpl)this.config);
    }

    public FopFactoryConfig buildConfig() {
        return this.buildConfiguration();
    }

    FopFactoryConfig buildConfiguration() {
        this.fopFactoryConfigBuilder = CompletedFopFactoryConfigBuilder.INSTANCE;
        return this.config;
    }

    public FopFactory build() {
        return FopFactory.newInstance(this.buildConfiguration());
    }

    URI getBaseURI() {
        return this.config.getBaseURI();
    }

    public FontManager getFontManager() {
        return this.config.getFontManager();
    }

    public ImageManager getImageManager() {
        return this.config.getImageManager();
    }

    public FopFactoryBuilder setAccessibility(boolean enableAccessibility) {
        this.fopFactoryConfigBuilder.setAccessibility(enableAccessibility);
        return this;
    }

    public FopFactoryBuilder setKeepEmptyTags(boolean b) {
        this.fopFactoryConfigBuilder.setKeepEmptyTags(b);
        return this;
    }

    public FopFactoryBuilder setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
        this.fopFactoryConfigBuilder.setLayoutManagerMakerOverride(lmMaker);
        return this;
    }

    public FopFactoryBuilder setBaseURI(URI baseURI) {
        this.fopFactoryConfigBuilder.setBaseURI(baseURI);
        return this;
    }

    public FopFactoryBuilder setHyphenBaseResourceResolver(InternalResourceResolver hyphenationResourceResolver) {
        this.fopFactoryConfigBuilder.setHyphenationResourceResolver(hyphenationResourceResolver);
        return this;
    }

    public FopFactoryBuilder setStrictFOValidation(boolean validateStrictly) {
        this.fopFactoryConfigBuilder.setStrictFOValidation(validateStrictly);
        return this;
    }

    public FopFactoryBuilder setStrictUserConfigValidation(boolean validateStrictly) {
        this.fopFactoryConfigBuilder.setStrictUserConfigValidation(validateStrictly);
        return this;
    }

    public FopFactoryBuilder setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
        this.fopFactoryConfigBuilder.setBreakIndentInheritanceOnReferenceAreaBoundary(value);
        return this;
    }

    public FopFactoryBuilder setSourceResolution(float dpi) {
        this.fopFactoryConfigBuilder.setSourceResolution(dpi);
        return this;
    }

    public FopFactoryBuilder setTargetResolution(float dpi) {
        this.fopFactoryConfigBuilder.setTargetResolution(dpi);
        return this;
    }

    public FopFactoryBuilder setPageHeight(String pageHeight) {
        this.fopFactoryConfigBuilder.setPageHeight(pageHeight);
        return this;
    }

    public FopFactoryBuilder setPageWidth(String pageWidth) {
        this.fopFactoryConfigBuilder.setPageWidth(pageWidth);
        return this;
    }

    public FopFactoryBuilder ignoreNamespace(String namespaceURI) {
        this.fopFactoryConfigBuilder.ignoreNamespace(namespaceURI);
        return this;
    }

    public FopFactoryBuilder ignoreNamespaces(Collection<String> namespaceURIs) {
        this.fopFactoryConfigBuilder.ignoreNamespaces(namespaceURIs);
        return this;
    }

    public FopFactoryBuilder setConfiguration(Configuration cfg) {
        this.fopFactoryConfigBuilder.setConfiguration(cfg);
        return this;
    }

    public FopFactoryBuilder setPreferRenderer(boolean preferRenderer) {
        this.fopFactoryConfigBuilder.setPreferRenderer(preferRenderer);
        return this;
    }

    public FopFactoryBuilder setComplexScriptFeatures(boolean csf) {
        this.fopFactoryConfigBuilder.setComplexScriptFeaturesEnabled(csf);
        return this;
    }

    public FopFactoryBuilder setHyphPatNames(Map<String, String> hyphPatNames) {
        this.fopFactoryConfigBuilder.setHyphPatNames(hyphPatNames);
        return this;
    }

    public FopFactoryBuilder setTableBorderOverpaint(boolean b) {
        this.fopFactoryConfigBuilder.setTableBorderOverpaint(b);
        return this;
    }

    private static final class ActiveFopFactoryConfigBuilder
    implements FopFactoryConfigBuilder {
        private final FopFactoryConfigImpl config;

        private ActiveFopFactoryConfigBuilder(FopFactoryConfigImpl config) {
            this.config = config;
        }

        @Override
        public void setAccessibility(boolean enableAccessibility) {
            this.config.accessibility = enableAccessibility;
        }

        @Override
        public void setKeepEmptyTags(boolean b) {
            this.config.keepEmptyTags = b;
        }

        @Override
        public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
            this.config.layoutManagerMaker = lmMaker;
        }

        @Override
        public void setBaseURI(URI baseURI) {
            this.config.baseURI = baseURI;
        }

        @Override
        public void setHyphenationResourceResolver(InternalResourceResolver hyphenationResourceResolver) {
            this.config.hyphenationResourceResolver = hyphenationResourceResolver;
        }

        @Override
        public void setStrictFOValidation(boolean validateStrictly) {
            this.config.hasStrictFOValidation = validateStrictly;
        }

        @Override
        public void setStrictUserConfigValidation(boolean validateStrictly) {
            this.config.hasStrictUserValidation = validateStrictly;
        }

        @Override
        public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
            this.config.breakIndentInheritanceOnReferenceBoundary = value;
        }

        @Override
        public void setSourceResolution(float dpi) {
            this.config.sourceResolution = dpi;
        }

        @Override
        public void setTargetResolution(float dpi) {
            this.config.targetResolution = dpi;
        }

        @Override
        public void setPageHeight(String pageHeight) {
            this.config.pageHeight = pageHeight;
        }

        @Override
        public void setPageWidth(String pageWidth) {
            this.config.pageWidth = pageWidth;
        }

        @Override
        public void ignoreNamespace(String namespaceURI) {
            this.config.ignoredNamespaces.add(namespaceURI);
        }

        @Override
        public void ignoreNamespaces(Collection<String> namespaceURIs) {
            this.config.ignoredNamespaces.addAll(namespaceURIs);
        }

        @Override
        public void setConfiguration(Configuration cfg) {
            this.config.cfg = cfg;
        }

        @Override
        public void setPreferRenderer(boolean preferRenderer) {
            this.config.preferRenderer = preferRenderer;
        }

        @Override
        public void setComplexScriptFeaturesEnabled(boolean csf) {
            this.config.isComplexScript = csf;
        }

        @Override
        public void setHyphPatNames(Map<String, String> hyphPatNames) {
            this.config.hyphPatNames = hyphPatNames;
        }

        @Override
        public void setTableBorderOverpaint(boolean b) {
            this.config.tableBorderOverpaint = b;
        }
    }

    private static final class CompletedFopFactoryConfigBuilder
    implements FopFactoryConfigBuilder {
        private static final CompletedFopFactoryConfigBuilder INSTANCE = new CompletedFopFactoryConfigBuilder();

        private CompletedFopFactoryConfigBuilder() {
        }

        private void throwIllegalStateException() {
            throw new IllegalStateException("The final FOP Factory configuration has already been built");
        }

        @Override
        public void setAccessibility(boolean enableAccessibility) {
            this.throwIllegalStateException();
        }

        @Override
        public void setKeepEmptyTags(boolean b) {
            this.throwIllegalStateException();
        }

        @Override
        public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
            this.throwIllegalStateException();
        }

        @Override
        public void setBaseURI(URI baseURI) {
            this.throwIllegalStateException();
        }

        @Override
        public void setHyphenationResourceResolver(InternalResourceResolver hyphenationResourceResolver) {
            this.throwIllegalStateException();
        }

        @Override
        public void setStrictFOValidation(boolean validateStrictly) {
            this.throwIllegalStateException();
        }

        @Override
        public void setStrictUserConfigValidation(boolean validateStrictly) {
            this.throwIllegalStateException();
        }

        @Override
        public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean value) {
            this.throwIllegalStateException();
        }

        @Override
        public void setSourceResolution(float dpi) {
            this.throwIllegalStateException();
        }

        @Override
        public void setTargetResolution(float dpi) {
            this.throwIllegalStateException();
        }

        @Override
        public void setPageHeight(String pageHeight) {
            this.throwIllegalStateException();
        }

        @Override
        public void setPageWidth(String pageWidth) {
            this.throwIllegalStateException();
        }

        @Override
        public void ignoreNamespace(String namespaceURI) {
            this.throwIllegalStateException();
        }

        @Override
        public void ignoreNamespaces(Collection<String> namespaceURIs) {
            this.throwIllegalStateException();
        }

        @Override
        public void setConfiguration(Configuration cfg) {
            this.throwIllegalStateException();
        }

        @Override
        public void setPreferRenderer(boolean preferRenderer) {
            this.throwIllegalStateException();
        }

        @Override
        public void setComplexScriptFeaturesEnabled(boolean csf) {
            this.throwIllegalStateException();
        }

        @Override
        public void setHyphPatNames(Map<String, String> hyphPatNames) {
            this.throwIllegalStateException();
        }

        @Override
        public void setTableBorderOverpaint(boolean b) {
            this.throwIllegalStateException();
        }
    }

    private static interface FopFactoryConfigBuilder {
        public void setAccessibility(boolean var1);

        public void setKeepEmptyTags(boolean var1);

        public void setLayoutManagerMakerOverride(LayoutManagerMaker var1);

        public void setBaseURI(URI var1);

        public void setHyphenationResourceResolver(InternalResourceResolver var1);

        public void setStrictFOValidation(boolean var1);

        public void setStrictUserConfigValidation(boolean var1);

        public void setBreakIndentInheritanceOnReferenceAreaBoundary(boolean var1);

        public void setSourceResolution(float var1);

        public void setTargetResolution(float var1);

        public void setPageHeight(String var1);

        public void setPageWidth(String var1);

        public void ignoreNamespace(String var1);

        public void ignoreNamespaces(Collection<String> var1);

        public void setConfiguration(Configuration var1);

        public void setPreferRenderer(boolean var1);

        public void setComplexScriptFeaturesEnabled(boolean var1);

        public void setHyphPatNames(Map<String, String> var1);

        public void setTableBorderOverpaint(boolean var1);
    }

    public static class FopFactoryConfigImpl
    implements FopFactoryConfig {
        private final EnvironmentProfile enviro;
        private final ImageManager imageManager;
        private boolean accessibility;
        private boolean keepEmptyTags = true;
        private LayoutManagerMaker layoutManagerMaker;
        private URI baseURI;
        private InternalResourceResolver hyphenationResourceResolver;
        private boolean hasStrictFOValidation = true;
        private boolean hasStrictUserValidation = true;
        private boolean breakIndentInheritanceOnReferenceBoundary = false;
        private float sourceResolution = 72.0f;
        private float targetResolution = 72.0f;
        private String pageHeight = "11in";
        private String pageWidth = "8.26in";
        private Set<String> ignoredNamespaces = new HashSet<String>();
        private Configuration cfg;
        private boolean preferRenderer;
        private boolean isComplexScript = true;
        private Map<String, String> hyphPatNames;
        private boolean tableBorderOverpaint;

        FopFactoryConfigImpl(EnvironmentProfile enviro) {
            this.enviro = enviro;
            this.baseURI = enviro.getDefaultBaseURI();
            this.imageManager = new ImageManager(new ImageContextImpl(this));
        }

        @Override
        public boolean isAccessibilityEnabled() {
            return this.accessibility;
        }

        @Override
        public boolean isKeepEmptyTags() {
            return this.keepEmptyTags;
        }

        @Override
        public LayoutManagerMaker getLayoutManagerMakerOverride() {
            return this.layoutManagerMaker;
        }

        @Override
        public ResourceResolver getResourceResolver() {
            return this.enviro.getResourceResolver();
        }

        @Override
        public URI getBaseURI() {
            return this.baseURI;
        }

        @Override
        public InternalResourceResolver getHyphenationResourceResolver() {
            return this.hyphenationResourceResolver;
        }

        @Override
        public boolean validateStrictly() {
            return this.hasStrictFOValidation;
        }

        @Override
        public boolean validateUserConfigStrictly() {
            return this.hasStrictUserValidation;
        }

        @Override
        public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
            return this.breakIndentInheritanceOnReferenceBoundary;
        }

        @Override
        public float getSourceResolution() {
            return this.sourceResolution;
        }

        @Override
        public float getTargetResolution() {
            return this.targetResolution;
        }

        @Override
        public String getPageHeight() {
            return this.pageHeight;
        }

        @Override
        public String getPageWidth() {
            return this.pageWidth;
        }

        @Override
        public Set<String> getIgnoredNamespaces() {
            return Collections.unmodifiableSet(this.ignoredNamespaces);
        }

        @Override
        public boolean isNamespaceIgnored(String namespace) {
            return this.ignoredNamespaces.contains(namespace);
        }

        @Override
        public Configuration getUserConfig() {
            return this.cfg;
        }

        @Override
        public boolean preferRenderer() {
            return this.preferRenderer;
        }

        @Override
        public FontManager getFontManager() {
            return this.enviro.getFontManager();
        }

        @Override
        public ImageManager getImageManager() {
            return this.imageManager;
        }

        @Override
        public boolean isComplexScriptFeaturesEnabled() {
            return this.isComplexScript;
        }

        @Override
        public boolean isTableBorderOverpaint() {
            return this.tableBorderOverpaint;
        }

        @Override
        public Map<String, String> getHyphenationPatternNames() {
            return this.hyphPatNames;
        }

        @Override
        public AbstractImageSessionContext.FallbackResolver getFallbackResolver() {
            return this.enviro.getFallbackResolver();
        }

        private static final class ImageContextImpl
        implements ImageContext {
            private final FopFactoryConfig config;

            ImageContextImpl(FopFactoryConfig config) {
                this.config = config;
            }

            @Override
            public float getSourceResolution() {
                return this.config.getSourceResolution();
            }
        }
    }
}

