/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.ImageWMF;
import org.apache.fop.util.UnclosableInputStream;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.io.XmlSourceUtil;

public class PreloaderWMF
extends AbstractImagePreloader {
    private static Log log = LogFactory.getLog(PreloaderWMF.class);
    private boolean batikAvailable = true;

    @Override
    public ImageInfo preloadImage(String uri, Source src, ImageContext context) throws IOException {
        if (!ImageUtil.hasInputStream(src)) {
            return null;
        }
        ImageInfo info = null;
        if (this.batikAvailable) {
            try {
                Loader loader = new Loader();
                info = loader.getImage(uri, src, context);
            }
            catch (NoClassDefFoundError e) {
                this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)e);
                return null;
            }
        }
        if (info != null) {
            XmlSourceUtil.closeQuietly(src);
        }
        return info;
    }

    private final class Loader {
        private Loader() {
        }

        private ImageInfo getImage(String uri, Source src, ImageContext context) {
            UnclosableInputStream in = new UnclosableInputStream(XmlSourceUtil.needInputStream(src));
            try {
                ((InputStream)in).mark(5);
                DataInputStream din = new DataInputStream(in);
                int magic = EndianUtils.swapInteger((int)din.readInt());
                din.reset();
                if (magic != -1698247209) {
                    IOUtils.closeQuietly((InputStream)din);
                    return null;
                }
                WMFRecordStore wmfStore = new WMFRecordStore();
                wmfStore.read(din);
                IOUtils.closeQuietly((InputStream)din);
                int width = wmfStore.getWidthUnits();
                int height = wmfStore.getHeightUnits();
                int dpi = wmfStore.getMetaFileUnitsPerInch();
                ImageInfo info = new ImageInfo(uri, "image/x-wmf");
                ImageSize size = new ImageSize();
                size.setSizeInPixels(width, height);
                size.setResolution(dpi);
                size.calcSizeFromPixels();
                info.setSize(size);
                ImageWMF img = new ImageWMF(info, wmfStore);
                info.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, img);
                return info;
            }
            catch (NoClassDefFoundError ncdfe) {
                try {
                    ((InputStream)in).reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                PreloaderWMF.this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)ncdfe);
                return null;
            }
            catch (IOException e) {
                log.debug((Object)("Error while trying to load stream as an WMF file: " + e.getMessage()));
                try {
                    ((InputStream)in).reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
    }
}

