/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder;

import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderComponent;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.LatLng;
import com.google.code.geocoder.model.LatLngBounds;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.EnumMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Geocoder {
    private static final Logger logger = LoggerFactory.getLogger(Geocoder.class);
    private static final String GEOCODE_REQUEST_HOST = "maps.googleapis.com";
    private static final String GEOCODE_REQUEST_SERVER_HTTP = "http://maps.googleapis.com";
    private static final String GEOCODE_REQUEST_SERVER_HTTPS = "https://maps.googleapis.com";
    private static final String GEOCODE_REQUEST_QUERY_BASIC = "/maps/api/geocode/json?sensor=false";
    private static final String ENCODING = "UTF-8";
    private final String clientId;
    private final Mac mac;

    public Geocoder() {
        this.clientId = null;
        this.mac = null;
    }

    public Geocoder(String clientId, String clientKey) throws InvalidKeyException {
        if (clientId == null || clientId.length() == 0) {
            throw new IllegalArgumentException("ClientId is not defined");
        }
        if (clientKey == null || clientKey.length() == 0) {
            throw new IllegalArgumentException("ClientKey is not defined");
        }
        this.clientId = clientId;
        this.mac = Geocoder.getMAC(clientKey);
    }

    public GeocodeResponse geocode(GeocoderRequest geocoderRequest) throws IOException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        String urlString = this.getURL(geocoderRequest);
        return this.request(gson, urlString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GeocodeResponse request(Gson gson, String urlString) throws IOException {
        URL url = new URL(urlString);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), ENCODING));
        try {
            GeocodeResponse geocodeResponse = gson.fromJson((Reader)reader, GeocodeResponse.class);
            return geocodeResponse;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public static String getGeocoderHost() {
        return GEOCODE_REQUEST_HOST;
    }

    protected String getURL(GeocoderRequest geocoderRequest) throws UnsupportedEncodingException {
        logger.trace("Request {}", (Object)geocoderRequest);
        StringBuilder url = this.getURLQuery(geocoderRequest);
        if (this.mac == null) {
            url.insert(0, GEOCODE_REQUEST_SERVER_HTTP);
        } else {
            this.addClientIdAndSignURL(url);
            url.insert(0, GEOCODE_REQUEST_SERVER_HTTPS);
        }
        logger.trace("FULL Request URL: {}", (Object)url);
        return url.toString();
    }

    protected StringBuilder getURLQuery(GeocoderRequest geocoderRequest) throws UnsupportedEncodingException {
        String channel = geocoderRequest.getChannel();
        String address = geocoderRequest.getAddress();
        LatLngBounds bounds = geocoderRequest.getBounds();
        String language = geocoderRequest.getLanguage();
        String region = geocoderRequest.getRegion();
        LatLng location = geocoderRequest.getLocation();
        EnumMap<GeocoderComponent, String> components = geocoderRequest.getComponents();
        StringBuilder url = new StringBuilder(GEOCODE_REQUEST_QUERY_BASIC);
        if (channel != null && channel.length() > 0) {
            url.append("&channel=").append(URLEncoder.encode(channel, ENCODING));
        }
        if (address != null && address.length() > 0) {
            url.append("&address=").append(URLEncoder.encode(address, ENCODING));
        } else if (location != null) {
            url.append("&latlng=").append(URLEncoder.encode(location.toUrlValue(), ENCODING));
        } else {
            throw new IllegalArgumentException("Address or location must be defined");
        }
        if (language != null && language.length() > 0) {
            url.append("&language=").append(URLEncoder.encode(language, ENCODING));
        }
        if (region != null && region.length() > 0) {
            url.append("&region=").append(URLEncoder.encode(region, ENCODING));
        }
        if (bounds != null) {
            url.append("&bounds=").append(URLEncoder.encode(bounds.getSouthwest().toUrlValue() + "|" + bounds.getNortheast().toUrlValue(), ENCODING));
        }
        if (!components.isEmpty()) {
            url.append("&components=");
            boolean isFirstLine = true;
            for (Map.Entry<GeocoderComponent, String> entry : components.entrySet()) {
                if (isFirstLine) {
                    isFirstLine = false;
                } else {
                    url.append(URLEncoder.encode("|", ENCODING));
                }
                url.append(URLEncoder.encode(entry.getKey().value(), ENCODING));
                url.append(':');
                url.append(URLEncoder.encode(entry.getValue(), ENCODING));
            }
        }
        logger.trace("URL query: {}", (Object)url);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClientIdAndSignURL(StringBuilder url) throws UnsupportedEncodingException {
        byte[] sigBytes;
        url.append("&client=").append(URLEncoder.encode(this.clientId, ENCODING));
        logger.trace("URL query to Sign: {}", (Object)url);
        Mac mac = this.mac;
        synchronized (mac) {
            this.mac.update(url.toString().getBytes());
            sigBytes = this.mac.doFinal();
        }
        String signature = new String(Base64.encodeBase64((byte[])sigBytes));
        signature = signature.replace('+', '-');
        signature = signature.replace('/', '_');
        if (logger.isTraceEnabled()) {
            logger.trace("Signature: [{}] for URL query {}", (Object)signature, (Object)url);
        }
        url.append("&signature=").append(signature);
    }

    protected static Mac getMAC(String clientKey) throws InvalidKeyException {
        try {
            byte[] key = clientKey.replace('-', '+').replace('_', '/').getBytes();
            byte[] decodedKey = Base64.decodeBase64((byte[])key);
            SecretKeySpec sha1Key = new SecretKeySpec(decodedKey, "HmacSHA1");
            Mac result = Mac.getInstance("HmacSHA1");
            result.init(sha1Key);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

