/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.geocoder.model;

import java.io.Serializable;
import java.math.BigDecimal;

public class LatLng
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PRECISION = 6;
    private BigDecimal lat;
    private BigDecimal lng;

    public LatLng() {
    }

    public LatLng(BigDecimal lat, BigDecimal lng) {
        this.lat = lat;
        this.lng = lng;
    }

    public LatLng(String lat, String lng) {
        this.lat = new BigDecimal(lat);
        this.lng = new BigDecimal(lng);
    }

    public BigDecimal getLat() {
        return this.lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public BigDecimal getLng() {
        return this.lng;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }

    public String toUrlValue() {
        return this.toUrlValue(6);
    }

    public String toUrlValue(int precision) {
        return this.lat.setScale(precision, 6).toString() + "," + this.lng.setScale(precision, 6).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLng latLng = (LatLng)o;
        if (this.lat != null ? !this.lat.equals(latLng.lat) : latLng.lat != null) {
            return false;
        }
        return !(this.lng != null ? !this.lng.equals(latLng.lng) : latLng.lng != null);
    }

    public int hashCode() {
        int result = this.lat != null ? this.lat.hashCode() : 0;
        result = 31 * result + (this.lng != null ? this.lng.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LatLng{lat=" + this.lat + ", lng=" + this.lng + '}';
    }
}

