/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGitConsumer.class);
    private final GitEndpoint endpoint;
    private Repository repo;
    private Git git;

    public AbstractGitConsumer(GitEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.repo = this.getLocalRepository();
        this.git = new Git(this.repo);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.repo.close();
        this.git.close();
    }

    private Repository getLocalRepository() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = null;
        try {
            repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(this.endpoint.getLocalPath(), ".git"))).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            LOG.error("There was an error, cannot open {} repository", (Object)this.endpoint.getLocalPath());
            throw e;
        }
        return repo;
    }

    protected Repository getRepository() {
        return this.repo;
    }

    protected Git getGit() {
        return this.git;
    }

    protected abstract int poll() throws Exception;
}

