/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitCommitConsumer
extends AbstractGitConsumer {
    private List commitsConsumed = new ArrayList();

    public GitCommitConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        int count = 0;
        Object commits = this.getGit().log().all().call();
        Iterator iterator = commits.iterator();
        while (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            if (this.commitsConsumed.contains(commit.getId())) continue;
            Exchange e = this.getEndpoint().createExchange();
            e.getOut().setBody((Object)commit);
            this.getProcessor().process(e);
            this.commitsConsumed.add(commit.getId());
            ++count;
        }
        return count;
    }
}

