/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.producer;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GitProducer.class);
    private final GitEndpoint endpoint;
    private Repository repo;
    private Git git;

    public GitProducer(GitEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.repo = this.getLocalRepository();
        this.git = new Git(this.repo);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.repo.close();
        this.git.close();
    }

    public void process(Exchange exchange) throws Exception {
        String operation = ObjectHelper.isEmpty((Object)this.endpoint.getOperation()) ? (String)exchange.getIn().getHeader("CamelGitOperation", String.class) : this.endpoint.getOperation();
        if (ObjectHelper.isEmpty((Object)this.endpoint.getLocalPath())) {
            throw new IllegalArgumentException("Local path must specified to execute " + operation);
        }
        switch (operation) {
            case "clone": {
                this.doClone(exchange, operation);
                break;
            }
            case "init": {
                this.doInit(exchange, operation);
                break;
            }
            case "add": {
                this.doAdd(exchange, operation);
                break;
            }
            case "cherryPick": {
                this.doCherryPick(exchange, operation);
                break;
            }
            case "remove": {
                this.doRemove(exchange, operation);
                break;
            }
            case "commit": {
                this.doCommit(exchange, operation);
                break;
            }
            case "commitAll": {
                this.doCommitAll(exchange, operation);
                break;
            }
            case "createBranch": {
                this.doCreateBranch(exchange, operation);
                break;
            }
            case "deleteBranch": {
                this.doDeleteBranch(exchange, operation);
                break;
            }
            case "status": {
                this.doStatus(exchange, operation);
                break;
            }
            case "log": {
                this.doLog(exchange, operation);
                break;
            }
            case "push": {
                this.doPush(exchange, operation);
                break;
            }
            case "pushTag": {
                this.doPushTag(exchange, operation);
                break;
            }
            case "pull": {
                this.doPull(exchange, operation);
                break;
            }
            case "merge": {
                this.doMerge(exchange, operation);
                break;
            }
            case "createTag": {
                this.doCreateTag(exchange, operation);
                break;
            }
            case "deleteTag": {
                this.doDeleteTag(exchange, operation);
                break;
            }
            case "showBranches": {
                this.doShowBranches(exchange, operation);
                break;
            }
            case "showTags": {
                this.doShowTags(exchange, operation);
                break;
            }
            case "clean": {
                this.doClean(exchange, operation);
                break;
            }
            case "gc": {
                this.doGc(exchange, operation);
                break;
            }
            case "remoteAdd": {
                this.doRemoteAdd(exchange, operation);
                break;
            }
            case "remoteList": {
                this.doRemoteList(exchange, operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    protected void doClone(Exchange exchange, String operation) throws Exception {
        block10: {
            Git result = null;
            if (ObjectHelper.isEmpty((Object)this.endpoint.getLocalPath())) {
                throw new IllegalArgumentException("Local path must specified to execute " + operation);
            }
            try {
                File localRepo = new File(this.endpoint.getLocalPath(), "");
                if (!localRepo.exists()) {
                    if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                        UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                        result = ((CloneCommand)Git.cloneRepository().setCredentialsProvider(credentials)).setURI(this.endpoint.getRemotePath()).setDirectory(new File(this.endpoint.getLocalPath(), "")).call();
                    } else {
                        result = Git.cloneRepository().setURI(this.endpoint.getRemotePath()).setDirectory(new File(this.endpoint.getLocalPath(), "")).call();
                    }
                    break block10;
                }
                throw new IllegalArgumentException("The local repository directory already exists");
            }
            catch (Exception e) {
                LOG.error("There was an error in Git {} operation", (Object)operation);
                throw e;
            }
            finally {
                if (ObjectHelper.isNotEmpty(result)) {
                    result.close();
                }
            }
        }
    }

    protected void doInit(Exchange exchange, String operation) throws Exception {
        Git result = null;
        if (ObjectHelper.isEmpty((Object)this.endpoint.getLocalPath())) {
            throw new IllegalArgumentException("Local path must specified to execute " + operation);
        }
        try {
            result = Git.init().setDirectory(new File(this.endpoint.getLocalPath(), "")).setBare(false).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        finally {
            if (ObjectHelper.isNotEmpty(result)) {
                result.close();
            }
        }
    }

    protected void doAdd(Exchange exchange, String operation) throws Exception {
        String fileName = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitFilename"))) {
            throw new IllegalArgumentException("File name must be specified to execute " + operation);
        }
        fileName = (String)exchange.getIn().getHeader("CamelGitFilename", String.class);
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            this.git.add().addFilepattern(fileName).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doRemove(Exchange exchange, String operation) throws Exception {
        String fileName = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitFilename"))) {
            throw new IllegalArgumentException("File name must be specified to execute " + operation);
        }
        fileName = (String)exchange.getIn().getHeader("CamelGitFilename", String.class);
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            this.git.rm().addFilepattern(fileName).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doCommit(Exchange exchange, String operation) throws Exception {
        String commitMessage = null;
        String username = null;
        String email = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitMessage"))) {
            throw new IllegalArgumentException("Commit message must be specified to execute " + operation);
        }
        commitMessage = (String)exchange.getIn().getHeader("CamelGitCommitMessage", String.class);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitUsername")) && ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitEmail"))) {
            username = (String)exchange.getIn().getHeader("CamelGitCommitUsername", String.class);
            email = (String)exchange.getIn().getHeader("CamelGitCommitEmail", String.class);
        }
        boolean allowEmpty = this.endpoint.isAllowEmpty();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitAllowEmpty"))) {
            allowEmpty = (Boolean)exchange.getIn().getHeader("CamelGitAllowEmpty", Boolean.class);
        }
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            if (ObjectHelper.isNotEmpty((Object)username) && ObjectHelper.isNotEmpty((Object)email)) {
                this.git.commit().setAllowEmpty(allowEmpty).setCommitter(username, email).setMessage(commitMessage).call();
            } else {
                this.git.commit().setAllowEmpty(allowEmpty).setMessage(commitMessage).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doCommitAll(Exchange exchange, String operation) throws Exception {
        String commitMessage = null;
        String username = null;
        String email = null;
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitMessage"))) {
            throw new IllegalArgumentException("Commit message must be specified to execute " + operation);
        }
        commitMessage = (String)exchange.getIn().getHeader("CamelGitCommitMessage", String.class);
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitUsername")) && ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitEmail"))) {
            username = (String)exchange.getIn().getHeader("CamelGitCommitUsername", String.class);
            email = (String)exchange.getIn().getHeader("CamelGitCommitEmail", String.class);
        }
        boolean allowEmpty = this.endpoint.isAllowEmpty();
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitAllowEmpty"))) {
            allowEmpty = (Boolean)exchange.getIn().getHeader("CamelGitAllowEmpty", Boolean.class);
        }
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            if (ObjectHelper.isNotEmpty((Object)username) && ObjectHelper.isNotEmpty((Object)email)) {
                this.git.commit().setAllowEmpty(allowEmpty).setAll(true).setCommitter(username, email).setMessage(commitMessage).call();
            } else {
                this.git.commit().setAllowEmpty(allowEmpty).setAll(true).setMessage(commitMessage).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doCreateBranch(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getBranchName())) {
            throw new IllegalArgumentException("Branch Name must be specified to execute " + operation);
        }
        try {
            this.git.branchCreate().setName(this.endpoint.getBranchName()).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doDeleteBranch(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getBranchName())) {
            throw new IllegalArgumentException("Branch Name must be specified to execute " + operation);
        }
        try {
            this.git.branchDelete().setBranchNames(this.endpoint.getBranchName()).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doStatus(Exchange exchange, String operation) throws Exception {
        Status status = null;
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            status = this.git.status().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, status);
    }

    protected void doLog(Exchange exchange, String operation) throws Exception {
        Object revCommit = null;
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            revCommit = this.git.log().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, revCommit);
    }

    protected void doPush(Exchange exchange, String operation) throws Exception {
        Object result = null;
        try {
            if (ObjectHelper.isEmpty((Object)this.endpoint.getRemoteName())) {
                throw new IllegalArgumentException("Remote name must be specified to execute " + operation);
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                result = ((PushCommand)this.git.push().setCredentialsProvider(credentials)).setRemote(this.endpoint.getRemoteName()).call();
            } else {
                result = this.git.push().setRemote(this.endpoint.getRemoteName()).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doPushTag(Exchange exchange, String operation) throws Exception {
        Object result = null;
        try {
            if (ObjectHelper.isEmpty((Object)this.endpoint.getRemoteName())) {
                throw new IllegalArgumentException("Remote name must be specified to execute " + operation);
            }
            if (ObjectHelper.isEmpty((Object)this.endpoint.getTagName())) {
                throw new IllegalArgumentException("Tag Name must be specified to execute " + operation);
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                result = ((PushCommand)this.git.push().setCredentialsProvider(credentials)).setRemote(this.endpoint.getRemoteName()).add("refs/tags/" + this.endpoint.getTagName()).call();
            } else {
                result = this.git.push().setRemote(this.endpoint.getRemoteName()).add("refs/tags/" + this.endpoint.getTagName()).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doPull(Exchange exchange, String operation) throws Exception {
        PullResult result = null;
        try {
            if (ObjectHelper.isEmpty((Object)this.endpoint.getRemoteName())) {
                throw new IllegalArgumentException("Remote name must be specified to execute " + operation);
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getUsername()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getPassword())) {
                UsernamePasswordCredentialsProvider credentials = new UsernamePasswordCredentialsProvider(this.endpoint.getUsername(), this.endpoint.getPassword());
                result = ((PullCommand)this.git.pull().setCredentialsProvider(credentials)).setRemote(this.endpoint.getRemoteName()).call();
            } else {
                result = this.git.pull().setRemote(this.endpoint.getRemoteName()).call();
            }
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doMerge(Exchange exchange, String operation) throws Exception {
        MergeResult result = null;
        try {
            if (ObjectHelper.isEmpty((Object)this.endpoint.getBranchName())) {
                throw new IllegalArgumentException("Branch name must be specified to execute " + operation);
            }
            ObjectId mergeBase = this.git.getRepository().resolve(this.endpoint.getBranchName());
            this.git.checkout().setName("master").call();
            result = this.git.merge().include(mergeBase).setFastForward(MergeCommand.FastForwardMode.FF).setCommit(true).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doCreateTag(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getTagName())) {
            throw new IllegalArgumentException("Tag Name must be specified to execute " + operation);
        }
        try {
            this.git.tag().setName(this.endpoint.getTagName()).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doDeleteTag(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getTagName())) {
            throw new IllegalArgumentException("Tag Name must be specified to execute " + operation);
        }
        try {
            this.git.tagDelete().setTags(this.endpoint.getTagName()).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
    }

    protected void doShowBranches(Exchange exchange, String operation) throws Exception {
        Object result = null;
        try {
            result = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doShowTags(Exchange exchange, String operation) throws Exception {
        Object result = null;
        try {
            result = this.git.tagList().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doCherryPick(Exchange exchange, String operation) throws Exception {
        CherryPickResult result = null;
        String commitId = null;
        try {
            if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelGitCommitId"))) {
                throw new IllegalArgumentException("Commit id must be specified to execute " + operation);
            }
            commitId = (String)exchange.getIn().getHeader("CamelGitCommitId", String.class);
            RevWalk walk = new RevWalk(this.repo);
            ObjectId id = this.repo.resolve(commitId);
            RevCommit commit = walk.parseCommit(id);
            walk.dispose();
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            result = this.git.cherryPick().include(commit).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doClean(Exchange exchange, String operation) throws Exception {
        Object result = null;
        try {
            if (ObjectHelper.isNotEmpty((Object)this.endpoint.getBranchName())) {
                this.git.checkout().setCreateBranch(false).setName(this.endpoint.getBranchName()).call();
            }
            result = this.git.clean().setCleanDirectories(true).call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doGc(Exchange exchange, String operation) throws Exception {
        Properties result = null;
        try {
            result = this.git.gc().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doRemoteAdd(Exchange exchange, String operation) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.endpoint.getRemoteName())) {
            throw new IllegalArgumentException("Remote Name must be specified to execute " + operation);
        }
        if (ObjectHelper.isEmpty((Object)this.endpoint.getRemotePath())) {
            throw new IllegalArgumentException("Remote Path must be specified to execute " + operation);
        }
        RemoteConfig result = null;
        try {
            RemoteAddCommand remoteAddCommand = this.git.remoteAdd();
            remoteAddCommand.setUri(new URIish(this.endpoint.getRemotePath()));
            remoteAddCommand.setName(this.endpoint.getRemoteName());
            result = remoteAddCommand.call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    protected void doRemoteList(Exchange exchange, String operation) throws Exception {
        Object result = null;
        try {
            result = this.git.remoteList().call();
        }
        catch (Exception e) {
            LOG.error("There was an error in Git {} operation", (Object)operation);
            throw e;
        }
        this.updateExchange(exchange, result);
    }

    private Repository getLocalRepository() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository repo = null;
        try {
            repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(this.endpoint.getLocalPath(), ".git"))).readEnvironment()).findGitDir()).build();
        }
        catch (IOException e) {
            LOG.error("There was an error, cannot open {} repository", (Object)this.endpoint.getLocalPath());
            throw e;
        }
        return repo;
    }

    private void updateExchange(Exchange exchange, Object body) {
        exchange.getOut().setBody(body);
        MessageHelper.copyHeaders((Message)exchange.getIn(), (Message)exchange.getOut(), (boolean)true);
    }
}

