/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.consumer.AbstractGitConsumer;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.lib.Ref;

public class GitBranchConsumer
extends AbstractGitConsumer {
    private List branchesConsumed = new ArrayList();

    public GitBranchConsumer(GitEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        int count = 0;
        Object call = this.getGit().branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
        Iterator iterator = call.iterator();
        while (iterator.hasNext()) {
            Ref ref = (Ref)iterator.next();
            if (this.branchesConsumed.contains(ref.getName())) continue;
            Exchange e = this.createExchange(true);
            e.getMessage().setBody(ref.getName());
            e.getMessage().setHeader("CamelGitBranchLeaf", ref.getLeaf().getName());
            e.getMessage().setHeader("CamelGitBranchObjectId", ref.getObjectId().getName());
            this.getProcessor().process(e);
            this.branchesConsumed.add(ref.getName());
            ++count;
        }
        return count;
    }
}

