/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ClientStreamReadyObserver;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedResponseObserver;
import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

@BetaApi(value="The surface for tracing is not stable and might change in the future")
@InternalApi(value="For internal use by google-cloud-java clients only")
public class TracedBidiCallable<RequestT, ResponseT>
extends BidiStreamingCallable<RequestT, ResponseT> {
    @Nonnull
    private final ApiTracerFactory tracerFactory;
    @Nonnull
    private final SpanName spanName;
    @Nonnull
    private final BidiStreamingCallable<RequestT, ResponseT> innerCallable;

    public TracedBidiCallable(@Nonnull BidiStreamingCallable<RequestT, ResponseT> innerCallable, @Nonnull ApiTracerFactory tracerFactory, @Nonnull SpanName spanName) {
        this.tracerFactory = Preconditions.checkNotNull(tracerFactory, "tracerFactory can't be null");
        this.spanName = Preconditions.checkNotNull(spanName, "spanName can't be null");
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "innerCallable can't be null");
    }

    @Override
    public ClientStream<RequestT> internalCall(ResponseObserver<ResponseT> responseObserver, ClientStreamReadyObserver<RequestT> onReady, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.BidiStreaming);
        context = context.withTracer(tracer);
        AtomicBoolean wasCancelled = new AtomicBoolean();
        TracedResponseObserver<ResponseT> tracedObserver = new TracedResponseObserver<ResponseT>(tracer, responseObserver, wasCancelled);
        TracedClientStreamReadyObserver<RequestT> tracedReadyObserver = new TracedClientStreamReadyObserver<RequestT>(tracer, onReady, wasCancelled);
        try {
            ClientStream<RequestT> clientStream = this.innerCallable.internalCall(tracedObserver, tracedReadyObserver, context);
            return new TracingClientStream(tracer, clientStream, wasCancelled);
        }
        catch (RuntimeException e) {
            tracer.operationFailed(e);
            throw e;
        }
    }

    private static class TracingClientStream<RequestT>
    implements ClientStream<RequestT> {
        private final ApiTracer tracer;
        private final ClientStream<RequestT> innerStream;
        private final AtomicBoolean wasCancelled;

        private TracingClientStream(ApiTracer tracer, ClientStream<RequestT> innerStream, AtomicBoolean wasCancelled) {
            this.tracer = tracer;
            this.innerStream = innerStream;
            this.wasCancelled = wasCancelled;
        }

        @Override
        public void send(RequestT request) {
            this.tracer.requestSent();
            this.innerStream.send(request);
        }

        @Override
        public void closeSendWithError(Throwable t2) {
            if (t2 == null) {
                t2 = new CancellationException();
            }
            this.wasCancelled.set(true);
            this.innerStream.closeSendWithError(t2);
        }

        @Override
        public void closeSend() {
            this.innerStream.closeSend();
        }

        @Override
        public boolean isSendReady() {
            return this.innerStream.isSendReady();
        }
    }

    private static class TracedClientStreamReadyObserver<RequestT>
    implements ClientStreamReadyObserver<RequestT> {
        private final ApiTracer tracer;
        private final ClientStreamReadyObserver<RequestT> innerObserver;
        private final AtomicBoolean wasCancelled;

        TracedClientStreamReadyObserver(ApiTracer tracer, ClientStreamReadyObserver<RequestT> innerObserver, AtomicBoolean wasCancelled) {
            this.tracer = tracer;
            this.innerObserver = innerObserver;
            this.wasCancelled = wasCancelled;
        }

        @Override
        public void onReady(ClientStream<RequestT> stream) {
            this.innerObserver.onReady(new TracingClientStream(this.tracer, stream, this.wasCancelled));
        }
    }
}

