/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.RetryHelper;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.HttpRpcContext;
import java.util.concurrent.Callable;
import java.util.function.Function;

final class Retrying {
    Retrying() {
    }

    static <T, U> U run(StorageOptions options, ResultRetryAlgorithm<?> algorithm, Callable<T> c, Function<T, U> f) {
        HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
        try {
            httpRpcContext.newInvocationId();
            T result = RetryHelper.runWithRetries(c, options.getRetrySettings(), algorithm, options.getClock());
            U u = result == null ? null : (U)f.apply(result);
            return u;
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.coalesce(e);
        }
        finally {
            httpRpcContext.clearInvocationId();
        }
    }
}

