/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.component.google.storage.GoogleCloudStorageEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-storage")
public class GoogleCloudStorageComponent
extends DefaultComponent {
    @Metadata
    private GoogleCloudStorageConfiguration configuration = new GoogleCloudStorageConfiguration();

    public GoogleCloudStorageComponent() {
        this(null);
    }

    public GoogleCloudStorageComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Bucket name must be specified.");
        }
        if (remaining.startsWith("arn:")) {
            remaining = remaining.substring(remaining.lastIndexOf(58) + 1);
        }
        GoogleCloudStorageConfiguration configuration = this.configuration != null ? this.configuration.copy() : new GoogleCloudStorageConfiguration();
        configuration.setBucketName(remaining);
        GoogleCloudStorageEndpoint endpoint = new GoogleCloudStorageEndpoint(uri, this, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public GoogleCloudStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleCloudStorageConfiguration configuration) {
        this.configuration = configuration;
    }
}

